/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.util.Map;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.ext.AcknowledgedMessagesSessionExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcknowledgedMessagesExtension
extends BayeuxServer.Extension.Adapter {
    private final Logger _logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMeta(ServerSession remote, ServerMessage.Mutable message) {
        if ("/meta/handshake".equals(message.getChannel()) && message.isSuccessful()) {
            boolean clientRequestedAcks;
            ServerMessage.Mutable rcv = message.getAssociated();
            Map rcvExt = rcv.getExt();
            boolean bl = clientRequestedAcks = rcvExt != null && rcvExt.get("ack") == Boolean.TRUE;
            if (clientRequestedAcks && remote != null) {
                ServerSessionImpl session = (ServerSessionImpl)remote;
                this._logger.debug("Enabled message acknowledgement for session {}", (Object)session);
                AcknowledgedMessagesSessionExtension extension = new AcknowledgedMessagesSessionExtension(session);
                Object object = session.getLock();
                synchronized (object) {
                    session.addExtension(extension);
                    extension.importMessages(session);
                }
            }
            Map sndExt = message.getExt(true);
            sndExt.put("ack", Boolean.TRUE);
        }
        return true;
    }
}

