/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.cometd.oort.Oort;
import org.cometd.oort.OortObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OortContainer<T>
extends OortObject<T> {
    private static final Map<String, Object> STALE_UPDATE = new HashMap<String, Object>();
    private final Map<String, Updater> updaters = new ConcurrentHashMap<String, Updater>();
    private final Logger logger;

    public OortContainer(Oort oort, String name, OortObject.Factory<T> factory) {
        super(oort, name, factory);
        this.logger = LoggerFactory.getLogger((String)Oort.loggerName(this.getClass(), oort.getURL(), name));
    }

    @Override
    protected void doStop() {
        super.doStop();
        this.updaters.clear();
    }

    @Override
    public void cometLeft(Oort.CometListener.Event event) {
        super.cometLeft(event);
        this.updaters.remove(event.getCometURL());
    }

    @Override
    protected void onObject(Map<String, Object> data) {
        String oortURL = (String)data.get("oort.info.url");
        Updater updater = this.updater(oortURL);
        if (this.isItemUpdate(data)) {
            OortObject.Info info = this.getInfo(oortURL);
            if (info == null) {
                updater.enqueue(data);
                this.pullInfo(oortURL);
            } else if (info.isLocal()) {
                this.onItem(info, data);
            } else {
                updater.enqueue(data);
                this.process(info, updater);
            }
        } else {
            super.onObject(data);
            OortObject.Info info = this.getInfo(oortURL);
            if (info != null) {
                updater.pulling = false;
                updater.version = info.getVersion();
                this.process(info, updater);
            }
        }
    }

    private Updater updater(String oortURL) {
        Updater updater = this.updaters.get(oortURL);
        if (updater == null) {
            updater = new Updater();
            this.updaters.put(oortURL, updater);
        }
        return updater;
    }

    private void process(OortObject.Info<T> info, Updater updater) {
        Map data;
        while ((data = updater.dequeue()) != null) {
            if (data == STALE_UPDATE) {
                if (!updater.pulling) {
                    updater.pulling = true;
                    this.pullInfo(info.getOortURL());
                }
                return;
            }
            this.onItem(info, data);
        }
        return;
    }

    protected abstract boolean isItemUpdate(Map<String, Object> var1);

    protected abstract void onItem(OortObject.Info<T> var1, Map<String, Object> var2);

    private class Updater {
        private final Queue<Map<String, Object>> updates = new PriorityQueue<Map<String, Object>>(2, new VersionComparator());
        private boolean pulling;
        private long version;

        private Updater() {
        }

        private void enqueue(Map<String, Object> data) {
            this.updates.offer(data);
        }

        private Map<String, Object> dequeue() {
            long actual;
            while (true) {
                Map<String, Object> result = this.updates.peek();
                if (OortContainer.this.logger.isDebugEnabled()) {
                    OortContainer.this.logger.debug("Dequeued update version={}, data={}", (Object)this.version, result);
                }
                if (result == null) {
                    return null;
                }
                actual = ((Number)result.get("oort.info.version")).longValue();
                if (actual > this.version) break;
                this.updates.poll();
            }
            long expected = this.version + 1L;
            if (actual > expected) {
                return STALE_UPDATE;
            }
            this.version = expected;
            return this.updates.poll();
        }
    }

    private static class VersionComparator
    implements Comparator<Map<String, Object>> {
        private VersionComparator() {
        }

        @Override
        public int compare(Map<String, Object> o1, Map<String, Object> o2) {
            long v1 = ((Number)o1.get("oort.info.version")).longValue();
            long v2 = ((Number)o2.get("oort.info.version")).longValue();
            return Long.compare(v1, v2);
        }
    }
}

