/*
 * Decompiled with CFR 0.152.
 */
package org.codingmatters.poom.ci.service.bundle;

import com.fasterxml.jackson.core.JsonFactory;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.codingmatters.poom.client.PoomjobsRunnerRegistryAPIClient;
import org.codingmatters.poom.client.PoomjobsRunnerRegistryAPIHandlersClient;
import org.codingmatters.poom.poomjobs.domain.jobs.repositories.JobRepository;
import org.codingmatters.poom.poomjobs.domain.runners.repositories.RunnerRepository;
import org.codingmatters.poom.runner.manager.DefaultRunnerClientFactory;
import org.codingmatters.poom.runner.manager.RunnerClientFactory;
import org.codingmatters.poom.runner.manager.RunnerInvokerListener;
import org.codingmatters.poom.services.domain.repositories.Repository;
import org.codingmatters.poom.services.logging.CategorizedLogger;
import org.codingmatters.poom.services.support.Env;
import org.codingmatters.poomjobs.service.PoomjobsJobRegistryAPI;
import org.codingmatters.poomjobs.service.PoomjobsJobRepositoryListener;
import org.codingmatters.poomjobs.service.PoomjobsRunnerRegistryAPI;
import org.codingmatters.poomjobs.service.api.PoomjobsJobRegistryAPIProcessor;
import org.codingmatters.poomjobs.service.api.PoomjobsRunnerRegistryAPIProcessor;
import org.codingmatters.rest.api.Processor;
import org.codingmatters.rest.api.client.okhttp.HttpClientWrapper;
import org.codingmatters.rest.api.client.okhttp.OkHttpClientWrapper;
import org.codingmatters.rest.api.processors.MatchingPathProcessor;
import org.codingmatters.rest.undertow.CdmHttpUndertowHandler;

public class PoomCIApisService {
    private static final CategorizedLogger log = CategorizedLogger.getLogger(PoomCIApisService.class);
    private Undertow server;
    private final int port;
    private final String host;
    private final JsonFactory jsonFactory;
    private final PoomjobsRunnerRegistryAPI runnerRegistryAPI;
    private final PoomjobsJobRegistryAPI jobRegistryAPI;

    public static void main(String[] args) {
        String host = Env.mandatory((String)"SERVICE_HOST").asString();
        int port = Env.mandatory((String)"SERVICE_PORT").asInteger();
        int clientPoolSize = Env.optional((String)"CLIENT_POOL_SIZE").orElse(new Env.Var("5")).asInteger();
        JsonFactory jsonFactory = new JsonFactory();
        AtomicInteger threadIndex = new AtomicInteger(1);
        ExecutorService clientPool = Executors.newFixedThreadPool(clientPoolSize, runnable -> new Thread(runnable, "client-pool-thread-" + threadIndex.getAndIncrement()));
        PoomjobsRunnerRegistryAPI runnerRegistryAPI = PoomCIApisService.runnerRegistryAPI();
        PoomCIApisService service = new PoomCIApisService(host, port, jsonFactory, runnerRegistryAPI, PoomCIApisService.jobRegistryAPI(runnerRegistryAPI, clientPool, jsonFactory, OkHttpClientWrapper.build()));
        service.start();
        log.info("poom-ci pipeline api service running");
        try {
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            log.info("poom-ci pipeline api service stopping...");
            service.stop();
            log.info("poom-ci pipeline api service stopped.");
            return;
        }
    }

    public static PoomjobsRunnerRegistryAPI runnerRegistryAPI() {
        Repository runnerRepository = RunnerRepository.createInMemory();
        return new PoomjobsRunnerRegistryAPI(runnerRepository);
    }

    public static PoomjobsJobRegistryAPI jobRegistryAPI(PoomjobsRunnerRegistryAPI runnerRegistryApi, ExecutorService clientPool, JsonFactory jsonFactory, HttpClientWrapper client) {
        Repository jobRepository = JobRepository.createInMemory();
        PoomjobsRunnerRegistryAPIHandlersClient runnerRegistryClient = new PoomjobsRunnerRegistryAPIHandlersClient(runnerRegistryApi.handlers(), clientPool);
        return new PoomjobsJobRegistryAPI(jobRepository, (PoomjobsJobRepositoryListener)new RunnerInvokerListener((PoomjobsRunnerRegistryAPIClient)runnerRegistryClient, (RunnerClientFactory)new DefaultRunnerClientFactory(jsonFactory, client)));
    }

    public PoomCIApisService(String host, int port, JsonFactory jsonFactory, PoomjobsRunnerRegistryAPI runnerRegistryAPI, PoomjobsJobRegistryAPI jobRegistryAPI) {
        this.port = port;
        this.host = host;
        this.jsonFactory = jsonFactory;
        this.runnerRegistryAPI = runnerRegistryAPI;
        this.jobRegistryAPI = jobRegistryAPI;
    }

    public void start() {
        this.server = Undertow.builder().addHttpListener(this.port, this.host).setHandler((HttpHandler)new CdmHttpUndertowHandler(this.processor())).build();
        this.server.start();
    }

    private Processor processor() {
        return MatchingPathProcessor.whenMatching((String)"/poomjobs-jobs/v1/.*", (Processor)new PoomjobsJobRegistryAPIProcessor("/poomjobs-jobs/v1", this.jsonFactory, this.jobRegistryAPI.handlers())).whenMatching("/poomjobs-runners/v1/.*", (Processor)new PoomjobsRunnerRegistryAPIProcessor("/poomjobs-runners/v1", this.jsonFactory, this.runnerRegistryAPI.handlers())).whenNoMatch((request, response) -> response.status(404).payload("{\"code\":\"NOT_FOUND\"}", "UTF-8"));
    }

    public void stop() {
        this.server.stop();
    }
}

