/*
 * Decompiled with CFR 0.152.
 */
package org.codenarc.report;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.text.SimpleTemplateEngine;
import groovy.text.TemplateEngine;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.codenarc.AnalysisContext;
import org.codenarc.report.ReportWriter;
import org.codenarc.results.Results;
import org.codenarc.rule.Rule;
import org.codenarc.util.AstUtil;
import org.codenarc.util.CodeNarcVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReportWriter
implements ReportWriter,
GroovyObject {
    protected static final String BASE_MESSAGES_BUNDLE = "codenarc-base-messages";
    protected static final String CUSTOM_MESSAGES_BUNDLE = "codenarc-messages";
    protected static final String CODENARC_URL = "https://codenarc.org";
    private static final Logger LOG;
    private String outputFile;
    private Object writeToStandardOut;
    protected Closure getTimestamp;
    protected String customMessagesBundleName;
    protected ResourceBundle resourceBundle;
    private ResourceBundle customMessagesResourceBundle;
    private final TemplateEngine templateEngine;
    protected Closure initializeResourceBundle;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public AbstractReportWriter() {
        MetaClass metaClass;
        String string;
        _closure1 _closure110 = new _closure1(this, this);
        this.getTimestamp = _closure110;
        this.customMessagesBundleName = string = CUSTOM_MESSAGES_BUNDLE;
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, SimpleTemplateEngine.class);
        this.templateEngine = IndyInterface.bootstrap("cast", "()", 0, callSite);
        _closure2 _closure210 = new _closure2(this, this);
        this.initializeResourceBundle = _closure210;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public abstract void writeReport(Writer var1, AnalysisContext var2, Results var3);

    @Override
    public void writeReport(AnalysisContext analysisContext, Results results) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            AnalysisContext analysisContext2 = analysisContext;
            valueRecorder.record((Object)analysisContext2, 8);
            if (IndyInterface.bootstrap("cast", "()", 0, analysisContext2) == false) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert analysisContext", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            Results results2 = results;
            valueRecorder2.record((Object)results2, 8);
            if (IndyInterface.bootstrap("cast", "()", 0, results2) == false) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert results", (ValueRecorder)valueRecorder2), null);
            }
            valueRecorder2.clear();
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWriteToStandardOut", 2, this)) != false) {
            IndyInterface.bootstrap("invoke", "writeReportToStandardOut", 2, this, analysisContext, results);
        } else {
            IndyInterface.bootstrap("invoke", "writeReportToFile", 2, this, analysisContext, results);
        }
    }

    public boolean isWriteToStandardOut() {
        return ScriptBytecodeAdapter.compareEqual((Object)this.writeToStandardOut, (Object)true) || ScriptBytecodeAdapter.compareEqual((Object)this.writeToStandardOut, (Object)"true");
    }

    private void writeReportToStandardOut(AnalysisContext analysisContext, Results results) {
        CallSite writer = IndyInterface.bootstrap("init", "<init>", 0, OutputStreamWriter.class, IndyInterface.bootstrap("getProperty", "out", 0, System.class));
        IndyInterface.bootstrap("invoke", "writeReport", 2, this, writer, analysisContext, results);
    }

    /*
     * WARNING - void declaration
     */
    private void writeReportToFile(AnalysisContext analysisContext, Results results) {
        void var2_2;
        Reference analysisContext2 = new Reference((Object)analysisContext);
        Reference results2 = new Reference((Object)var2_2);
        String string = this.outputFile;
        String outputFilename = IndyInterface.bootstrap("cast", "()", 0, string) != false ? string : IndyInterface.bootstrap("invoke", "getProperty", 2, this, "defaultOutputFile");
        CallSite outputFile = IndyInterface.bootstrap("init", "<init>", 0, File.class, outputFilename);
        IndyInterface.bootstrap("invoke", "mkdirs", 1, IndyInterface.bootstrap("invoke", "getParentFile", 0, outputFile));
        public final class _writeReportToFile_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference analysisContext;
            private /* synthetic */ Reference results;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _writeReportToFile_closure3(Object _outerInstance, Object _thisObject, Reference analysisContext, Reference results) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.analysisContext = reference2 = analysisContext;
                this.results = reference = results;
            }

            public Object doCall(Object writer) {
                return IndyInterface.bootstrap("invoke", "writeReport", 2, this, writer, IndyInterface.bootstrap("cast", "()", 0, this.analysisContext.get()), IndyInterface.bootstrap("cast", "()", 0, this.results.get()));
            }

            @Generated
            public AnalysisContext getAnalysisContext() {
                return IndyInterface.bootstrap("cast", "()", 0, this.analysisContext.get());
            }

            @Generated
            public Results getResults() {
                return IndyInterface.bootstrap("cast", "()", 0, this.results.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _writeReportToFile_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "withWriter", 0, outputFile, new _writeReportToFile_closure3(this, this, analysisContext2, results2));
        IndyInterface.bootstrap("invoke", "info", 0, LOG, new GStringImpl(new Object[]{outputFilename}, new String[]{"Report file [", "] created."}));
    }

    protected void initializeDefaultResourceBundle() {
        CallSite baseBundle = IndyInterface.bootstrap("invoke", "getBundle", 0, ResourceBundle.class, BASE_MESSAGES_BUNDLE);
        CallSite callSite = baseBundle;
        this.resourceBundle = IndyInterface.bootstrap("cast", "()", 0, callSite);
        try {
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "getBundle", 0, ResourceBundle.class, this.customMessagesBundleName);
            this.customMessagesResourceBundle = IndyInterface.bootstrap("cast", "()", 0, callSite2);
            IndyInterface.bootstrap("invoke", "info", 0, LOG, new GStringImpl(new Object[]{this.customMessagesBundleName}, new String[]{"Using custom message bundle [", "]"}));
        }
        catch (Exception MissingResourceException) {
            IndyInterface.bootstrap("invoke", "debug", 0, LOG, new GStringImpl(new Object[]{this.customMessagesBundleName}, new String[]{"No custom message bundle found for [", "]. Using default messages."}));
        }
    }

    protected String getHtmlDescriptionForRule(Rule rule) {
        CallSite callSite;
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "getDescriptionProperty", 2, this, rule);
        CallSite rawMessageText = IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : (IndyInterface.bootstrap("cast", "()", 0, callSite = IndyInterface.bootstrap("invoke", "getHtmlRuleDescription", 2, this, rule)) != false ? callSite : IndyInterface.bootstrap("invoke", "getRuleDescriptionOrDefaultMessage", 2, this, rule));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substituteMessageParametersIfPresent", 2, this, rule, rawMessageText));
    }

    protected String getDescriptionForRule(Rule rule) {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getDescriptionProperty", 2, this, rule);
        CallSite rawMessageText = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : IndyInterface.bootstrap("invoke", "getRuleDescriptionOrDefaultMessage", 2, this, rule);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substituteMessageParametersIfPresent", 2, this, rule, rawMessageText));
    }

    private String substituteMessageParametersIfPresent(Rule rule, String rawMessageText) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, rawMessageText, "${")) != false) {
            CallSite template = IndyInterface.bootstrap("invoke", "createTemplate", 0, this.templateEngine, rawMessageText);
            Map binding = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"rule", rule});
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "make", 0, template, binding));
        }
        return rawMessageText;
    }

    private String getHtmlRuleDescription(Rule rule) {
        CallSite resourceKey = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "name", 0, rule), ".description.html");
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getResourceBundleString", 2, this, resourceKey, null, false));
    }

    private String getRuleDescriptionOrDefaultMessage(Rule rule) {
        CallSite resourceKey = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "name", 0, rule), ".description");
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getResourceBundleString", 2, this, resourceKey, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, rule)}, new String[]{"No description provided for rule named [", "]"})));
    }

    private String getDescriptionProperty(Rule rule) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "respondsTo", 0, AstUtil.class, rule, "getDescription")) != false ? IndyInterface.bootstrap("getProperty", "description", 0, rule) : null);
    }

    protected String getResourceBundleString(String resourceKey, String defaultString, boolean logWarning) {
        Object string = defaultString;
        if (IndyInterface.bootstrap("cast", "()", 0, this.customMessagesResourceBundle) != false) {
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getString", 0, this.customMessagesResourceBundle, resourceKey));
            try {
                return callSite;
            }
            catch (MissingResourceException ignore) {
            }
        }
        try {
            string = IndyInterface.bootstrap("invoke", "getString", 0, this.resourceBundle, resourceKey);
        }
        catch (MissingResourceException ignore) {
            if (logWarning) {
                IndyInterface.bootstrap("invoke", "warn", 0, LOG, new GStringImpl(new Object[]{resourceKey}, new String[]{"No string found for resourceKey=[", "]"}));
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, string);
    }

    protected String getFormattedTimestamp() {
        CallSite dateFormat = IndyInterface.bootstrap("invoke", "getDateTimeInstance", 0, DateFormat.class);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "format", 0, dateFormat, ScriptBytecodeAdapter.invokeClosure((Object)this.getTimestamp, (Object[])new Object[0])));
    }

    protected List getSortedRules(AnalysisContext analysisContext) {
        public final class _getSortedRules_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getSortedRules_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object rule) {
                return IndyInterface.bootstrap("invoke", "isEnabled", 2, this, rule);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getSortedRules_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite rules = IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("getProperty", "rules", 0, IndyInterface.bootstrap("getProperty", "ruleSet", 4, analysisContext)), new _getSortedRules_closure4(this, this));
        public final class _getSortedRules_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getSortedRules_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object rule) {
                return IndyInterface.bootstrap("getProperty", "name", 0, rule);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getSortedRules_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "sort", 0, IndyInterface.bootstrap("invoke", "toList", 0, rules), new _getSortedRules_closure5(this, this)));
    }

    protected boolean isEnabled(Rule rule) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "respondsTo", 0, AstUtil.class, rule, "isEnabled")) == false || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "enabled", 0, rule));
    }

    protected String getCodeNarcVersion() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getVersion", 0, CodeNarcVersion.class));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AbstractReportWriter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    protected String getResourceBundleString(String resourceKey, String defaultString) {
        return this.getResourceBundleString(resourceKey, defaultString, true);
    }

    @Generated
    protected String getResourceBundleString(String resourceKey) {
        return this.getResourceBundleString(resourceKey, "?", true);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, AbstractReportWriter.class);
        LOG = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public String getOutputFile() {
        return this.outputFile;
    }

    @Generated
    public void setOutputFile(String string) {
        this.outputFile = string;
    }

    @Generated
    public Object getWriteToStandardOut() {
        return this.writeToStandardOut;
    }

    @Generated
    public void setWriteToStandardOut(Object object) {
        this.writeToStandardOut = object;
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            return IndyInterface.bootstrap("init", "<init>", 0, Date.class);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }
    }

    public final class _closure2
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure2(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            return IndyInterface.bootstrap("invoke", "initializeDefaultResourceBundle", 2, this);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure2.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }
    }
}

