/*
 * Decompiled with CFR 0.152.
 */
package org.codenarc.source;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.control.SourceUnit;

class ExpressionCollector {
    ExpressionCollector() {
    }

    Map<ClassNode, List<MethodCallExpression>> getMethodCalls(ModuleNode module) {
        HashMap<ClassNode, List<MethodCallExpression>> result = new HashMap<ClassNode, List<MethodCallExpression>>();
        if (module != null && module.getClasses() != null) {
            for (ClassNode classNode : module.getClasses()) {
                ExpressionCollectorVisitor collector = new ExpressionCollectorVisitor();
                collector.visitClass(classNode);
                result.put(classNode, collector.methodCalls);
            }
        }
        return result;
    }

    private static class ExpressionCollectorVisitor
    extends ClassCodeVisitorSupport {
        private final List<MethodCallExpression> methodCalls = new ArrayList<MethodCallExpression>();

        private ExpressionCollectorVisitor() {
        }

        public void visitMethodCallExpression(MethodCallExpression call) {
            if (!this.methodCalls.contains(call)) {
                this.methodCalls.add(call);
            }
            super.visitMethodCallExpression(call);
        }

        protected SourceUnit getSourceUnit() {
            throw new UnsupportedOperationException();
        }
    }
}

