/*
 * Decompiled with CFR 0.152.
 */
package org.codenarc.rule;

import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codenarc.rule.AbstractAstVisitorRule;
import org.codenarc.rule.AstVisitor;
import org.codenarc.rule.Violation;
import org.codenarc.source.SourceCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSharedAstVisitorRule
extends AbstractAstVisitorRule {
    protected abstract List<Violation> getViolations(AstVisitor var1, SourceCode var2);

    public void applyTo(SourceCode sourceCode, List violations) {
        if (!sourceCode.isValid()) {
            return;
        }
        AstVisitor visitor = this.getAstVisitor(sourceCode);
        this.applyVisitor(visitor, sourceCode);
        List<Violation> allViolations = this.getViolations(visitor, sourceCode);
        List<Violation> visitorViolations = this.removeSuppressedViolations(allViolations, sourceCode);
        violations.addAll(visitorViolations);
    }

    protected AstVisitor getAstVisitor(SourceCode sourceCode) {
        return super.getAstVisitor();
    }

    protected void applyVisitor(AstVisitor visitor, SourceCode sourceCode) {
        visitor.setRule(this);
        visitor.setSourceCode(sourceCode);
        for (ClassNode classNode : sourceCode.getAst().getClasses()) {
            if (!this.shouldApplyThisRuleTo(classNode)) continue;
            visitor.visitClass(classNode);
        }
    }

    private List<Violation> removeSuppressedViolations(List<Violation> violations, SourceCode sourceCode) {
        return sourceCode.getSuppressionAnalyzer().filterSuppressedViolations(violations);
    }
}

