/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb1;

import java.util.Date;
import org.codelibs.jcifs.smb1.Info;
import org.codelibs.jcifs.smb1.SmbComTransactionResponse;
import org.codelibs.jcifs.smb1.util.Hexdump;

class Trans2QueryPathInformationResponse
extends SmbComTransactionResponse {
    static final int SMB_QUERY_FILE_BASIC_INFO = 257;
    static final int SMB_QUERY_FILE_STANDARD_INFO = 258;
    private final int informationLevel;
    Info info;

    Trans2QueryPathInformationResponse(int informationLevel) {
        this.informationLevel = informationLevel;
        this.subCommand = (byte)5;
    }

    @Override
    int writeSetupWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    int writeParametersWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 2;
    }

    @Override
    int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        return switch (this.informationLevel) {
            case 257 -> this.readSmbQueryFileBasicInfoWireFormat(buffer, bufferIndex);
            case 258 -> this.readSmbQueryFileStandardInfoWireFormat(buffer, bufferIndex);
            default -> 0;
        };
    }

    int readSmbQueryFileStandardInfoWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        SmbQueryFileStandardInfo info = new SmbQueryFileStandardInfo();
        info.allocationSize = Trans2QueryPathInformationResponse.readInt8(buffer, bufferIndex);
        info.endOfFile = Trans2QueryPathInformationResponse.readInt8(buffer, bufferIndex += 8);
        info.numberOfLinks = Trans2QueryPathInformationResponse.readInt4(buffer, bufferIndex += 8);
        info.deletePending = (buffer[bufferIndex += 4] & 0xFF) > 0;
        int n = ++bufferIndex;
        info.directory = (buffer[n] & 0xFF) > 0;
        this.info = info;
        return ++bufferIndex - start;
    }

    int readSmbQueryFileBasicInfoWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        SmbQueryFileBasicInfo info = new SmbQueryFileBasicInfo();
        info.createTime = Trans2QueryPathInformationResponse.readTime(buffer, bufferIndex);
        info.lastAccessTime = Trans2QueryPathInformationResponse.readTime(buffer, bufferIndex += 8);
        info.lastWriteTime = Trans2QueryPathInformationResponse.readTime(buffer, bufferIndex += 8);
        info.changeTime = Trans2QueryPathInformationResponse.readTime(buffer, bufferIndex += 8);
        info.attributes = Trans2QueryPathInformationResponse.readInt2(buffer, bufferIndex += 8);
        this.info = info;
        return (bufferIndex += 2) - start;
    }

    @Override
    public String toString() {
        return "Trans2QueryPathInformationResponse[" + super.toString() + "]";
    }

    class SmbQueryFileStandardInfo
    implements Info {
        long allocationSize;
        long endOfFile;
        int numberOfLinks;
        boolean deletePending;
        boolean directory;

        SmbQueryFileStandardInfo() {
        }

        @Override
        public int getAttributes() {
            return 0;
        }

        @Override
        public long getCreateTime() {
            return 0L;
        }

        @Override
        public long getLastWriteTime() {
            return 0L;
        }

        @Override
        public long getSize() {
            return this.endOfFile;
        }

        public String toString() {
            return "SmbQueryInfoStandard[allocationSize=" + this.allocationSize + ",endOfFile=" + this.endOfFile + ",numberOfLinks=" + this.numberOfLinks + ",deletePending=" + this.deletePending + ",directory=" + this.directory + "]";
        }
    }

    class SmbQueryFileBasicInfo
    implements Info {
        long createTime;
        long lastAccessTime;
        long lastWriteTime;
        long changeTime;
        int attributes;

        SmbQueryFileBasicInfo() {
        }

        @Override
        public int getAttributes() {
            return this.attributes;
        }

        @Override
        public long getCreateTime() {
            return this.createTime;
        }

        @Override
        public long getLastWriteTime() {
            return this.lastWriteTime;
        }

        @Override
        public long getSize() {
            return 0L;
        }

        public String toString() {
            return "SmbQueryFileBasicInfo[createTime=" + String.valueOf(new Date(this.createTime)) + ",lastAccessTime=" + String.valueOf(new Date(this.lastAccessTime)) + ",lastWriteTime=" + String.valueOf(new Date(this.lastWriteTime)) + ",changeTime=" + String.valueOf(new Date(this.changeTime)) + ",attributes=0x" + Hexdump.toHexString(this.attributes, 4) + "]";
        }
    }
}

