/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb1;

import org.codelibs.jcifs.smb1.FileEntry;
import org.codelibs.jcifs.smb1.util.Hexdump;

public class SmbShareInfo
implements FileEntry {
    protected String netName;
    protected int type;
    protected String remark;

    public SmbShareInfo() {
    }

    public SmbShareInfo(String netName, int type, String remark) {
        this.netName = netName;
        this.type = type;
        this.remark = remark;
    }

    @Override
    public String getName() {
        return this.netName;
    }

    @Override
    public int getType() {
        switch (this.type & 0xFFFF) {
            case 1: {
                return 32;
            }
            case 3: {
                return 16;
            }
        }
        return 8;
    }

    @Override
    public int getAttributes() {
        return 17;
    }

    @Override
    public long createTime() {
        return 0L;
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public long length() {
        return 0L;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SmbShareInfo) {
            SmbShareInfo si = (SmbShareInfo)obj;
            return this.netName.equals(si.netName);
        }
        return false;
    }

    public int hashCode() {
        return this.netName.hashCode();
    }

    public String toString() {
        return "SmbShareInfo[netName=" + this.netName + ",type=0x" + Hexdump.toHexString(this.type, 8) + ",remark=" + this.remark + "]";
    }
}

