/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb1;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import org.codelibs.jcifs.smb1.SmbComReadAndX;
import org.codelibs.jcifs.smb1.SmbComReadAndXResponse;
import org.codelibs.jcifs.smb1.SmbComWrite;
import org.codelibs.jcifs.smb1.SmbComWriteAndX;
import org.codelibs.jcifs.smb1.SmbComWriteAndXResponse;
import org.codelibs.jcifs.smb1.SmbComWriteResponse;
import org.codelibs.jcifs.smb1.SmbException;
import org.codelibs.jcifs.smb1.SmbFile;
import org.codelibs.jcifs.smb1.util.Encdec;

public class SmbRandomAccessFile
implements DataOutput,
DataInput {
    private static final int WRITE_OPTIONS = 2114;
    private final SmbFile file;
    private long fp;
    private int openFlags;
    private int access = 0;
    private final int readSize;
    private final int writeSize;
    private int ch;
    private int options = 0;
    private final byte[] tmp = new byte[8];
    private SmbComWriteAndXResponse write_andx_resp = null;

    public SmbRandomAccessFile(String url, String mode, int shareAccess) throws SmbException, MalformedURLException, UnknownHostException {
        this(new SmbFile(url, "", null, shareAccess), mode);
    }

    public SmbRandomAccessFile(SmbFile file, String mode) throws SmbException, MalformedURLException, UnknownHostException {
        this.file = file;
        if (mode.equals("r")) {
            this.openFlags = 17;
        } else if (mode.equals("rw")) {
            this.openFlags = 23;
            this.write_andx_resp = new SmbComWriteAndXResponse();
            this.options = 2114;
            this.access = 3;
        } else {
            throw new IllegalArgumentException("Invalid mode");
        }
        file.open(this.openFlags, this.access, 128, this.options);
        this.readSize = file.tree.session.transport.rcv_buf_size - 70;
        this.writeSize = file.tree.session.transport.snd_buf_size - 70;
        this.fp = 0L;
    }

    public int read() throws SmbException {
        if (this.read(this.tmp, 0, 1) == -1) {
            return -1;
        }
        return this.tmp[0] & 0xFF;
    }

    public int read(byte[] b) throws SmbException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws SmbException {
        int r;
        int n;
        if (len <= 0) {
            return 0;
        }
        long start = this.fp;
        if (!this.file.isOpen()) {
            this.file.open(this.openFlags, 0, 128, this.options);
        }
        SmbComReadAndXResponse response = new SmbComReadAndXResponse(b, off);
        do {
            r = len > this.readSize ? this.readSize : len;
            this.file.send(new SmbComReadAndX(this.file.fid, this.fp, r, null), response);
            n = response.dataLength;
            if (n <= 0) {
                return (int)(this.fp - start > 0L ? this.fp - start : -1L);
            }
            this.fp += (long)n;
            response.off += n;
        } while ((len -= n) > 0 && n == r);
        return (int)(this.fp - start);
    }

    @Override
    public final void readFully(byte[] b) throws SmbException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws SmbException {
        int count;
        int n = 0;
        do {
            if ((count = this.read(b, off + n, len - n)) < 0) {
                throw new SmbException("EOF");
            }
            this.fp += (long)count;
        } while ((n += count) < len);
    }

    @Override
    public int skipBytes(int n) throws SmbException {
        if (n > 0) {
            this.fp += (long)n;
            return n;
        }
        return 0;
    }

    @Override
    public void write(int b) throws SmbException {
        this.tmp[0] = (byte)b;
        this.write(this.tmp, 0, 1);
    }

    @Override
    public void write(byte[] b) throws SmbException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws SmbException {
        if (len <= 0) {
            return;
        }
        if (!this.file.isOpen()) {
            this.file.open(this.openFlags, 0, 128, this.options);
        }
        do {
            int w = len > this.writeSize ? this.writeSize : len;
            this.file.send(new SmbComWriteAndX(this.file.fid, this.fp, len - w, b, off, w, null), this.write_andx_resp);
            this.fp += this.write_andx_resp.count;
            len = (int)((long)len - this.write_andx_resp.count);
            off = (int)((long)off + this.write_andx_resp.count);
        } while (len > 0);
    }

    public long getFilePointer() throws SmbException {
        return this.fp;
    }

    public void seek(long pos) throws SmbException {
        this.fp = pos;
    }

    public long length() throws SmbException {
        return this.file.length();
    }

    public void setLength(long newLength) throws SmbException {
        if (!this.file.isOpen()) {
            this.file.open(this.openFlags, 0, 128, this.options);
        }
        SmbComWriteResponse rsp = new SmbComWriteResponse();
        this.file.send(new SmbComWrite(this.file.fid, (int)(newLength & 0xFFFFFFFFL), 0, this.tmp, 0, 0), rsp);
    }

    public void close() throws SmbException {
        this.file.close();
    }

    @Override
    public final boolean readBoolean() throws SmbException {
        if (this.read(this.tmp, 0, 1) < 0) {
            throw new SmbException("EOF");
        }
        return this.tmp[0] != 0;
    }

    @Override
    public final byte readByte() throws SmbException {
        if (this.read(this.tmp, 0, 1) < 0) {
            throw new SmbException("EOF");
        }
        return this.tmp[0];
    }

    @Override
    public final int readUnsignedByte() throws SmbException {
        if (this.read(this.tmp, 0, 1) < 0) {
            throw new SmbException("EOF");
        }
        return this.tmp[0] & 0xFF;
    }

    @Override
    public final short readShort() throws SmbException {
        if (this.read(this.tmp, 0, 2) < 0) {
            throw new SmbException("EOF");
        }
        return Encdec.dec_uint16be(this.tmp, 0);
    }

    @Override
    public final int readUnsignedShort() throws SmbException {
        if (this.read(this.tmp, 0, 2) < 0) {
            throw new SmbException("EOF");
        }
        return Encdec.dec_uint16be(this.tmp, 0) & 0xFFFF;
    }

    @Override
    public final char readChar() throws SmbException {
        if (this.read(this.tmp, 0, 2) < 0) {
            throw new SmbException("EOF");
        }
        return (char)Encdec.dec_uint16be(this.tmp, 0);
    }

    @Override
    public final int readInt() throws SmbException {
        if (this.read(this.tmp, 0, 4) < 0) {
            throw new SmbException("EOF");
        }
        return Encdec.dec_uint32be(this.tmp, 0);
    }

    @Override
    public final long readLong() throws SmbException {
        if (this.read(this.tmp, 0, 8) < 0) {
            throw new SmbException("EOF");
        }
        return Encdec.dec_uint64be(this.tmp, 0);
    }

    @Override
    public final float readFloat() throws SmbException {
        if (this.read(this.tmp, 0, 4) < 0) {
            throw new SmbException("EOF");
        }
        return Encdec.dec_floatbe(this.tmp, 0);
    }

    @Override
    public final double readDouble() throws SmbException {
        if (this.read(this.tmp, 0, 8) < 0) {
            throw new SmbException("EOF");
        }
        return Encdec.dec_doublebe(this.tmp, 0);
    }

    @Override
    public final String readLine() throws SmbException {
        StringBuilder input = new StringBuilder();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    long cur = this.fp;
                    if (this.read() == 10) continue block4;
                    this.fp = cur;
                    continue block4;
                }
            }
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public final String readUTF() throws SmbException {
        int size = this.readUnsignedShort();
        byte[] b = new byte[size];
        this.read(b, 0, size);
        try {
            return Encdec.dec_utf8(b, 0, size);
        }
        catch (IOException ioe) {
            throw new SmbException("", (Throwable)ioe);
        }
    }

    @Override
    public final void writeBoolean(boolean v) throws SmbException {
        this.tmp[0] = (byte)(v ? 1 : 0);
        this.write(this.tmp, 0, 1);
    }

    @Override
    public final void writeByte(int v) throws SmbException {
        this.tmp[0] = (byte)v;
        this.write(this.tmp, 0, 1);
    }

    @Override
    public final void writeShort(int v) throws SmbException {
        Encdec.enc_uint16be((short)v, this.tmp, 0);
        this.write(this.tmp, 0, 2);
    }

    @Override
    public final void writeChar(int v) throws SmbException {
        Encdec.enc_uint16be((short)v, this.tmp, 0);
        this.write(this.tmp, 0, 2);
    }

    @Override
    public final void writeInt(int v) throws SmbException {
        Encdec.enc_uint32be(v, this.tmp, 0);
        this.write(this.tmp, 0, 4);
    }

    @Override
    public final void writeLong(long v) throws SmbException {
        Encdec.enc_uint64be(v, this.tmp, 0);
        this.write(this.tmp, 0, 8);
    }

    @Override
    public final void writeFloat(float v) throws SmbException {
        Encdec.enc_floatbe(v, this.tmp, 0);
        this.write(this.tmp, 0, 4);
    }

    @Override
    public final void writeDouble(double v) throws SmbException {
        Encdec.enc_doublebe(v, this.tmp, 0);
        this.write(this.tmp, 0, 8);
    }

    @Override
    public final void writeBytes(String s) throws SmbException {
        byte[] b = s.getBytes();
        this.write(b, 0, b.length);
    }

    @Override
    public final void writeChars(String s) throws SmbException {
        int clen = s.length();
        int blen = 2 * clen;
        byte[] b = new byte[blen];
        char[] c = new char[clen];
        s.getChars(0, clen, c, 0);
        int j = 0;
        for (int i = 0; i < clen; ++i) {
            b[j] = (byte)(c[i] >>> 8);
            int n = ++j;
            ++j;
            b[n] = (byte)(c[i] >>> 0);
        }
        this.write(b, 0, blen);
    }

    @Override
    public final void writeUTF(String str) throws SmbException {
        int len = str.length();
        int size = 0;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            size += ch > '\u007f' ? (ch > '\u07ff' ? 3 : 2) : 1;
        }
        byte[] dst = new byte[size];
        this.writeShort(size);
        try {
            Encdec.enc_utf8(str, dst, 0, size);
        }
        catch (IOException ioe) {
            throw new SmbException("", (Throwable)ioe);
        }
        this.write(dst, 0, size);
    }
}

