/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb1;

import org.codelibs.jcifs.smb1.ServerMessageBlock;
import org.codelibs.jcifs.smb1.util.Hexdump;

class SmbComRename
extends ServerMessageBlock {
    private final int searchAttributes;
    private final String oldFileName;
    private final String newFileName;

    SmbComRename(String oldFileName, String newFileName) {
        this.command = (byte)7;
        this.oldFileName = oldFileName;
        this.newFileName = newFileName;
        this.searchAttributes = 22;
    }

    @Override
    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        SmbComRename.writeInt2(this.searchAttributes, dst, dstIndex);
        return 2;
    }

    @Override
    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        dst[dstIndex] = 4;
        ++dstIndex;
        dstIndex += this.writeString(this.oldFileName, dst, dstIndex);
        dst[dstIndex++] = 4;
        if (this.useUnicode) {
            dst[dstIndex++] = 0;
        }
        dstIndex += this.writeString(this.newFileName, dst, dstIndex);
        return dstIndex - start;
    }

    @Override
    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return "SmbComRename[" + super.toString() + ",searchAttributes=0x" + Hexdump.toHexString(this.searchAttributes, 4) + ",oldFileName=" + this.oldFileName + ",newFileName=" + this.newFileName + "]";
    }
}

