/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.ntlmssp;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.Cipher;
import org.codelibs.jcifs.smb.CIFSContext;
import org.codelibs.jcifs.smb.CIFSException;
import org.codelibs.jcifs.smb.impl.NtlmUtil;
import org.codelibs.jcifs.smb.ntlmssp.NtlmMessage;
import org.codelibs.jcifs.smb.ntlmssp.Type2Message;
import org.codelibs.jcifs.smb.ntlmssp.av.AvFlags;
import org.codelibs.jcifs.smb.ntlmssp.av.AvPair;
import org.codelibs.jcifs.smb.ntlmssp.av.AvPairs;
import org.codelibs.jcifs.smb.ntlmssp.av.AvSingleHost;
import org.codelibs.jcifs.smb.ntlmssp.av.AvTargetName;
import org.codelibs.jcifs.smb.ntlmssp.av.AvTimestamp;
import org.codelibs.jcifs.smb.util.Crypto;
import org.codelibs.jcifs.smb.util.Hexdump;

public class Type3Message
extends NtlmMessage {
    private byte[] lmResponse;
    private byte[] ntResponse;
    private String domain;
    private String user;
    private String workstation;
    private byte[] masterKey = null;
    private byte[] sessionKey = null;
    private byte[] mic = null;
    private boolean micRequired;

    public Type3Message(CIFSContext tc) {
        this.setFlags(Type3Message.getDefaultFlags(tc));
        this.setDomain(tc.getConfig().getDefaultDomain());
        this.setUser(tc.getConfig().getDefaultUsername());
        this.setWorkstation(tc.getNameServiceClient().getLocalHost().getHostName());
    }

    public Type3Message(CIFSContext tc, Type2Message type2, String targetName, String password, String domain, String user, String workstation, int flags) throws GeneralSecurityException, CIFSException {
        this(tc, type2, targetName, password, domain, user, workstation, flags, false);
    }

    public Type3Message(CIFSContext tc, Type2Message type2, String targetName, String password, String domain, String user, String workstation, int flags, boolean nonAnonymous) throws GeneralSecurityException, CIFSException {
        this(tc, type2, targetName, null, password, domain, user, workstation, flags, nonAnonymous);
    }

    public Type3Message(CIFSContext tc, Type2Message type2, String targetName, byte[] passwordHash, String domain, String user, String workstation, int flags) throws CIFSException, GeneralSecurityException {
        this(tc, type2, targetName, passwordHash, null, domain, user, workstation, flags, true);
    }

    public Type3Message(CIFSContext tc, Type2Message type2, String targetName, byte[] passwordHash, String password, String domain, String user, String workstation, int flags, boolean nonAnonymous) throws GeneralSecurityException, CIFSException {
        this.setFlags(flags | Type3Message.getDefaultFlags(tc, type2));
        this.setWorkstation(workstation);
        this.setDomain(domain);
        this.setUser(user);
        if (password == null && passwordHash == null || !nonAnonymous && password != null && password.length() == 0) {
            this.setLMResponse(null);
            this.setNTResponse(null);
            return;
        }
        if (passwordHash == null) {
            passwordHash = NtlmUtil.getNTHash(password);
        }
        switch (tc.getConfig().getLanManCompatibility()) {
            case 0: 
            case 1: {
                if (!this.getFlag(524288)) {
                    this.setLMResponse(Type3Message.getLMResponse(tc, type2, password));
                    this.setNTResponse(Type3Message.getNTResponse(tc, type2, passwordHash));
                    break;
                }
                byte[] clientChallenge = new byte[24];
                tc.getConfig().getRandom().nextBytes(clientChallenge);
                Arrays.fill(clientChallenge, 8, 24, (byte)0);
                byte[] ntlm2Response = NtlmUtil.getNTLM2Response(passwordHash, type2.getChallenge(), clientChallenge);
                this.setLMResponse(clientChallenge);
                this.setNTResponse(ntlm2Response);
                byte[] sessionNonce = new byte[16];
                System.arraycopy(type2.getChallenge(), 0, sessionNonce, 0, 8);
                System.arraycopy(clientChallenge, 0, sessionNonce, 8, 8);
                MessageDigest md4 = Crypto.getMD4();
                md4.update(passwordHash);
                byte[] userSessionKey = md4.digest();
                MessageDigest hmac = Crypto.getHMACT64(userSessionKey);
                hmac.update(sessionNonce);
                byte[] ntlm2SessionKey = hmac.digest();
                if (this.getFlag(0x40000000)) {
                    this.masterKey = new byte[16];
                    tc.getConfig().getRandom().nextBytes(this.masterKey);
                    byte[] exchangedKey = new byte[16];
                    Cipher arcfour = Crypto.getArcfour(ntlm2SessionKey);
                    arcfour.update(this.masterKey, 0, 16, exchangedKey, 0);
                    this.setEncryptedSessionKey(exchangedKey);
                    break;
                }
                this.masterKey = ntlm2SessionKey;
                break;
            }
            case 2: {
                byte[] nt = Type3Message.getNTResponse(tc, type2, passwordHash);
                this.setLMResponse(nt);
                this.setNTResponse(nt);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                byte[] ntlmClientChallengeInfo = type2.getTargetInformation();
                List<AvPair> avPairs = ntlmClientChallengeInfo != null ? AvPairs.decode(ntlmClientChallengeInfo) : null;
                boolean haveTimestamp = AvPairs.contains(avPairs, 7);
                if (!haveTimestamp) {
                    byte[] lmClientChallenge = new byte[8];
                    tc.getConfig().getRandom().nextBytes(lmClientChallenge);
                    this.setLMResponse(Type3Message.getLMv2Response(tc, type2, domain, user, passwordHash, lmClientChallenge));
                } else {
                    this.setLMResponse(new byte[24]);
                }
                if (avPairs != null) {
                    this.setFlag(0x800000, true);
                }
                byte[] responseKeyNT = NtlmUtil.nTOWFv2(domain, user, passwordHash);
                byte[] ntlmClientChallenge = new byte[8];
                tc.getConfig().getRandom().nextBytes(ntlmClientChallenge);
                long ts = (System.currentTimeMillis() + 11644473600000L) * 10000L;
                if (haveTimestamp) {
                    ts = ((AvTimestamp)AvPairs.get(avPairs, 7)).getTimestamp();
                }
                this.setNTResponse(Type3Message.getNTLMv2Response(tc, type2, responseKeyNT, ntlmClientChallenge, this.makeAvPairs(tc, targetName, avPairs, haveTimestamp, ts), ts));
                MessageDigest hmac = Crypto.getHMACT64(responseKeyNT);
                hmac.update(this.ntResponse, 0, 16);
                byte[] userSessionKey = hmac.digest();
                if (this.getFlag(0x40000000)) {
                    this.masterKey = new byte[16];
                    tc.getConfig().getRandom().nextBytes(this.masterKey);
                    byte[] encryptedKey = new byte[16];
                    Cipher rc4 = Crypto.getArcfour(userSessionKey);
                    rc4.update(this.masterKey, 0, 16, encryptedKey, 0);
                    this.setEncryptedSessionKey(encryptedKey);
                    break;
                }
                this.masterKey = userSessionKey;
                break;
            }
            default: {
                this.setLMResponse(Type3Message.getLMResponse(tc, type2, password));
                this.setNTResponse(Type3Message.getNTResponse(tc, type2, passwordHash));
            }
        }
    }

    private byte[] makeAvPairs(CIFSContext tc, String targetName, List<AvPair> serverAvPairs, boolean haveServerTimestamp, long ts) {
        if (!tc.getConfig().isEnforceSpnegoIntegrity() && serverAvPairs == null) {
            return null;
        }
        if (serverAvPairs == null) {
            serverAvPairs = new LinkedList<AvPair>();
        }
        if (this.getFlag(16) && (tc.getConfig().isEnforceSpnegoIntegrity() || haveServerTimestamp && !tc.getConfig().isDisableSpnegoIntegrity())) {
            this.micRequired = true;
            this.mic = new byte[16];
            int curFlags = 0;
            AvFlags cur = (AvFlags)AvPairs.get(serverAvPairs, 6);
            if (cur != null) {
                curFlags = cur.getFlags();
            }
            AvPairs.replace(serverAvPairs, new AvFlags(curFlags |= 2));
        }
        AvPairs.replace(serverAvPairs, new AvTimestamp(ts));
        if (targetName != null) {
            AvPairs.replace(serverAvPairs, new AvTargetName(targetName));
        }
        AvPairs.replace(serverAvPairs, new AvPair(10, new byte[16]));
        AvPairs.replace(serverAvPairs, new AvSingleHost(tc.getConfig()));
        return AvPairs.encode(serverAvPairs);
    }

    public void setupMIC(byte[] type1, byte[] type2) throws GeneralSecurityException, IOException {
        byte[] sk = this.masterKey;
        if (sk == null) {
            return;
        }
        MessageDigest mac = Crypto.getHMACT64(sk);
        mac.update(type1);
        mac.update(type2);
        byte[] type3 = this.toByteArray();
        mac.update(type3);
        this.setMic(mac.digest());
    }

    public Type3Message(int flags, byte[] lmResponse, byte[] ntResponse, String domain, String user, String workstation) {
        this.setFlags(flags);
        this.setLMResponse(lmResponse);
        this.setNTResponse(ntResponse);
        this.setDomain(domain);
        this.setUser(user);
        this.setWorkstation(workstation);
    }

    public Type3Message(byte[] material) throws IOException {
        this.parse(material);
    }

    public static int getDefaultFlags(CIFSContext tc) {
        return 0x2000200 | (tc.getConfig().isUseUnicode() ? 1 : 2);
    }

    public static int getDefaultFlags(CIFSContext tc, Type2Message type2) {
        if (type2 == null) {
            return Type3Message.getDefaultFlags(tc);
        }
        int flags = 0x2000200;
        return flags |= type2.getFlag(1) ? 1 : 2;
    }

    public byte[] getLMResponse() {
        return this.lmResponse;
    }

    public void setLMResponse(byte[] lmResponse) {
        this.lmResponse = lmResponse;
    }

    public byte[] getNTResponse() {
        return this.ntResponse;
    }

    public void setNTResponse(byte[] ntResponse) {
        this.ntResponse = ntResponse;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getWorkstation() {
        return this.workstation;
    }

    public void setWorkstation(String workstation) {
        this.workstation = workstation;
    }

    public byte[] getMasterKey() {
        return this.masterKey;
    }

    public byte[] getEncryptedSessionKey() {
        return this.sessionKey;
    }

    public void setEncryptedSessionKey(byte[] sessionKey) {
        this.sessionKey = sessionKey;
    }

    public byte[] getMic() {
        return this.mic;
    }

    public void setMic(byte[] mic) {
        this.mic = mic;
    }

    public boolean isMICRequired() {
        return this.micRequired;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        byte[] micBytes;
        int size = 64;
        boolean unicode = this.getFlag(1);
        String oemCp = unicode ? null : Type3Message.getOEMEncoding();
        String domainName = this.getDomain();
        byte[] domainBytes = null;
        if (domainName != null && domainName.length() != 0) {
            domainBytes = unicode ? domainName.getBytes("UTF-16LE") : domainName.getBytes(oemCp);
            size += domainBytes.length;
        }
        String userName = this.getUser();
        byte[] userBytes = null;
        if (userName != null && userName.length() != 0) {
            userBytes = unicode ? userName.getBytes("UTF-16LE") : userName.toUpperCase().getBytes(oemCp);
            size += userBytes.length;
        }
        String workstationName = this.getWorkstation();
        byte[] workstationBytes = null;
        if (workstationName != null && workstationName.length() != 0) {
            workstationBytes = unicode ? workstationName.getBytes("UTF-16LE") : workstationName.toUpperCase().getBytes(oemCp);
            size += workstationBytes.length;
        }
        if ((micBytes = this.getMic()) != null) {
            size += 24;
        } else if (this.getFlag(0x2000000)) {
            size += 8;
        }
        byte[] lmResponseBytes = this.getLMResponse();
        size += lmResponseBytes != null ? lmResponseBytes.length : 0;
        byte[] ntResponseBytes = this.getNTResponse();
        size += ntResponseBytes != null ? ntResponseBytes.length : 0;
        byte[] sessionKeyBytes = this.getEncryptedSessionKey();
        byte[] type3 = new byte[size += sessionKeyBytes != null ? sessionKeyBytes.length : 0];
        int pos = 0;
        System.arraycopy(NTLMSSP_SIGNATURE, 0, type3, 0, 8);
        Type3Message.writeULong(type3, pos += 8, 3);
        pos += 4;
        int lmOff = Type3Message.writeSecurityBuffer(type3, 12, lmResponseBytes);
        pos += 8;
        int ntOff = Type3Message.writeSecurityBuffer(type3, 20, ntResponseBytes);
        pos += 8;
        int domOff = Type3Message.writeSecurityBuffer(type3, 28, domainBytes);
        pos += 8;
        int userOff = Type3Message.writeSecurityBuffer(type3, 36, userBytes);
        pos += 8;
        int wsOff = Type3Message.writeSecurityBuffer(type3, 44, workstationBytes);
        pos += 8;
        int skOff = Type3Message.writeSecurityBuffer(type3, 52, sessionKeyBytes);
        Type3Message.writeULong(type3, pos += 8, this.getFlags());
        pos += 4;
        if (this.getFlag(0x2000000)) {
            System.arraycopy(NTLMSSP_VERSION, 0, type3, pos, NTLMSSP_VERSION.length);
            pos += NTLMSSP_VERSION.length;
        } else if (micBytes != null) {
            pos += NTLMSSP_VERSION.length;
        }
        if (micBytes != null) {
            System.arraycopy(micBytes, 0, type3, pos, 16);
            pos += 16;
        }
        pos += Type3Message.writeSecurityBufferContent(type3, pos, lmOff, lmResponseBytes);
        pos += Type3Message.writeSecurityBufferContent(type3, pos, ntOff, ntResponseBytes);
        pos += Type3Message.writeSecurityBufferContent(type3, pos, domOff, domainBytes);
        pos += Type3Message.writeSecurityBufferContent(type3, pos, userOff, userBytes);
        pos += Type3Message.writeSecurityBufferContent(type3, pos, wsOff, workstationBytes);
        pos += Type3Message.writeSecurityBufferContent(type3, pos, skOff, sessionKeyBytes);
        return type3;
    }

    public String toString() {
        String userString = this.getUser();
        String domainString = this.getDomain();
        String workstationString = this.getWorkstation();
        byte[] lmResponseBytes = this.getLMResponse();
        byte[] ntResponseBytes = this.getNTResponse();
        byte[] sessionKeyBytes = this.getEncryptedSessionKey();
        return "Type3Message[domain=" + domainString + ",user=" + userString + ",workstation=" + workstationString + ",lmResponse=" + (String)(lmResponseBytes == null ? "null" : "<" + lmResponseBytes.length + " bytes>") + ",ntResponse=" + (String)(ntResponseBytes == null ? "null" : "<" + ntResponseBytes.length + " bytes>") + ",sessionKey=" + (String)(sessionKeyBytes == null ? "null" : "<" + sessionKeyBytes.length + " bytes>") + ",flags=0x" + Hexdump.toHexString(this.getFlags(), 8) + "]";
    }

    public static byte[] getLMResponse(CIFSContext tc, Type2Message type2, String password) throws GeneralSecurityException {
        if (type2 == null || password == null) {
            return null;
        }
        return NtlmUtil.getPreNTLMResponse(tc, password, type2.getChallenge());
    }

    public static byte[] getLMv2Response(CIFSContext tc, Type2Message type2, String domain, String user, String password, byte[] clientChallenge) throws GeneralSecurityException {
        if (password == null) {
            return null;
        }
        return Type3Message.getLMv2Response(tc, type2, domain, user, NtlmUtil.getNTHash(password), clientChallenge);
    }

    public static byte[] getLMv2Response(CIFSContext tc, Type2Message type2, String domain, String user, byte[] passwordHash, byte[] clientChallenge) throws GeneralSecurityException {
        if (type2 == null || domain == null || user == null || passwordHash == null || clientChallenge == null) {
            return null;
        }
        return NtlmUtil.getLMv2Response(domain, user, passwordHash, type2.getChallenge(), clientChallenge);
    }

    public static byte[] getNTLMv2Response(CIFSContext tc, Type2Message type2, byte[] responseKeyNT, byte[] clientChallenge, byte[] clientChallengeInfo, long ts) {
        if (type2 == null || responseKeyNT == null || clientChallenge == null) {
            return null;
        }
        return NtlmUtil.getNTLMv2Response(responseKeyNT, type2.getChallenge(), clientChallenge, ts, clientChallengeInfo);
    }

    public static byte[] getNTResponse(CIFSContext tc, Type2Message type2, String password) throws GeneralSecurityException {
        if (password == null) {
            return null;
        }
        return Type3Message.getNTResponse(tc, type2, NtlmUtil.getNTHash(password));
    }

    public static byte[] getNTResponse(CIFSContext tc, Type2Message type2, byte[] passwordHash) throws GeneralSecurityException {
        if (type2 == null || passwordHash == null) {
            return null;
        }
        return NtlmUtil.getNTLMResponse(passwordHash, type2.getChallenge());
    }

    private void parse(byte[] material) throws IOException {
        String charset;
        int pos = 0;
        for (int i = 0; i < 8; ++i) {
            if (material[i] == NTLMSSP_SIGNATURE[i]) continue;
            throw new IOException("Not an NTLMSSP message.");
        }
        if (Type3Message.readULong(material, pos += 8) != 3) {
            throw new IOException("Not a Type 3 message.");
        }
        byte[] lmResponseBytes = Type3Message.readSecurityBuffer(material, pos += 4);
        this.setLMResponse(lmResponseBytes);
        int lmResponseOffset = Type3Message.readULong(material, pos + 4);
        byte[] ntResponseBytes = Type3Message.readSecurityBuffer(material, pos += 8);
        this.setNTResponse(ntResponseBytes);
        int ntResponseOffset = Type3Message.readULong(material, pos + 4);
        byte[] domainBytes = Type3Message.readSecurityBuffer(material, pos += 8);
        int domainOffset = Type3Message.readULong(material, pos + 4);
        byte[] userBytes = Type3Message.readSecurityBuffer(material, pos += 8);
        int userOffset = Type3Message.readULong(material, pos + 4);
        byte[] workstationBytes = Type3Message.readSecurityBuffer(material, pos += 8);
        int workstationOffset = Type3Message.readULong(material, pos + 4);
        boolean end = false;
        if (lmResponseOffset < (pos += 8) + 12 || ntResponseOffset < pos + 12 || domainOffset < pos + 12 || userOffset < pos + 12 || workstationOffset < pos + 12) {
            int flags = 514;
            this.setFlags(flags);
            charset = Type3Message.getOEMEncoding();
            end = true;
        } else {
            this.setEncryptedSessionKey(Type3Message.readSecurityBuffer(material, pos));
            int flags = Type3Message.readULong(material, pos += 8);
            this.setFlags(flags);
            pos += 4;
            charset = (flags & 1) != 0 ? "UTF-16LE" : Type3Message.getOEMEncoding();
        }
        this.setDomain(new String(domainBytes, charset));
        this.setUser(new String(userBytes, charset));
        this.setWorkstation(new String(workstationBytes, charset));
        int micLen = pos + 24;
        if (end || lmResponseOffset < micLen || ntResponseOffset < micLen || domainOffset < micLen || userOffset < micLen || workstationOffset < micLen) {
            return;
        }
        byte[] m = new byte[16];
        System.arraycopy(material, pos += 8, m, 0, m.length);
        this.setMic(m);
    }
}

