/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.netbios;

import org.codelibs.jcifs.smb.CIFSException;

public class NbtException
extends CIFSException {
    private static final long serialVersionUID = 492638554095148960L;
    public static final int SUCCESS = 0;
    public static final int ERR_NAM_SRVC = 1;
    public static final int ERR_SSN_SRVC = 2;
    public static final int FMT_ERR = 1;
    public static final int SRV_ERR = 2;
    public static final int IMP_ERR = 4;
    public static final int RFS_ERR = 5;
    public static final int ACT_ERR = 6;
    public static final int CFT_ERR = 7;
    public static final int CONNECTION_REFUSED = -1;
    public static final int NOT_LISTENING_CALLED = 128;
    public static final int NOT_LISTENING_CALLING = 129;
    public static final int CALLED_NOT_PRESENT = 130;
    public static final int NO_RESOURCES = 131;
    public static final int UNSPECIFIED = 143;
    public int errorClass;
    public int errorCode;

    public static String getErrorString(int errorClass, int errorCode) {
        StringBuilder result = new StringBuilder();
        block0 : switch (errorClass) {
            case 0: {
                result.append("SUCCESS");
                break;
            }
            case 1: {
                result.append("ERR_NAM_SRVC/");
                switch (errorCode) {
                    case 1: {
                        result.append("FMT_ERR: Format Error");
                    }
                }
                result.append("Unknown error code: ").append(errorCode);
                break;
            }
            case 2: {
                result.append("ERR_SSN_SRVC/");
                switch (errorCode) {
                    case -1: {
                        result.append("Connection refused");
                        break block0;
                    }
                    case 128: {
                        result.append("Not listening on called name");
                        break block0;
                    }
                    case 129: {
                        result.append("Not listening for calling name");
                        break block0;
                    }
                    case 130: {
                        result.append("Called name not present");
                        break block0;
                    }
                    case 131: {
                        result.append("Called name present, but insufficient resources");
                        break block0;
                    }
                    case 143: {
                        result.append("Unspecified error");
                        break block0;
                    }
                }
                result.append("Unknown error code: ").append(errorCode);
                break;
            }
            default: {
                result.append("unknown error class: ").append(errorClass);
            }
        }
        return result.toString();
    }

    public NbtException(int errorClass, int errorCode) {
        super(NbtException.getErrorString(errorClass, errorCode));
        this.errorClass = errorClass;
        this.errorCode = errorCode;
    }

    @Override
    public String toString() {
        return "errorClass=" + this.errorClass + ",errorCode=" + this.errorCode + ",errorString=" + NbtException.getErrorString(this.errorClass, this.errorCode);
    }
}

