/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.netbios;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codelibs.jcifs.smb.CIFSContext;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.NameServiceClient;
import org.codelibs.jcifs.smb.NetbiosAddress;
import org.codelibs.jcifs.smb.ResolverType;
import org.codelibs.jcifs.smb.RuntimeCIFSException;
import org.codelibs.jcifs.smb.netbios.Lmhosts;
import org.codelibs.jcifs.smb.netbios.Name;
import org.codelibs.jcifs.smb.netbios.NameQueryRequest;
import org.codelibs.jcifs.smb.netbios.NameQueryResponse;
import org.codelibs.jcifs.smb.netbios.NameServicePacket;
import org.codelibs.jcifs.smb.netbios.NbtAddress;
import org.codelibs.jcifs.smb.netbios.NodeStatusRequest;
import org.codelibs.jcifs.smb.netbios.NodeStatusResponse;
import org.codelibs.jcifs.smb.netbios.UniAddress;
import org.codelibs.jcifs.smb.util.Hexdump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameServiceClientImpl
implements Runnable,
NameServiceClient {
    private static final int NAME_SERVICE_UDP_PORT = 137;
    static final byte[] UNKNOWN_MAC_ADDRESS = new byte[]{0, 0, 0, 0, 0, 0};
    private static final Logger log = LoggerFactory.getLogger(NameServiceClientImpl.class);
    private final Object LOCK = new Object();
    private int nbnsIndex = 0;
    private final Map<Name, CacheEntry> addressCache = new HashMap<Name, CacheEntry>();
    private final Set<Name> inFlightLookups = new HashSet<Name>();
    private final int lport;
    private int closeTimeout;
    private final byte[] snd_buf;
    private final byte[] rcv_buf;
    private DatagramSocket socket;
    private final DatagramPacket in;
    private final DatagramPacket out;
    private final Map<Integer, NameServicePacket> responseTable = new HashMap<Integer, NameServicePacket>();
    private Thread thread;
    private int nextNameTrnId = 0;
    private List<ResolverType> resolveOrder = new ArrayList<ResolverType>();
    private final InetAddress laddr;
    private final InetAddress baddr;
    private final CIFSContext transportContext;
    private NbtAddress localhostAddress;
    private final Lmhosts lmhosts = new Lmhosts();
    private Name unknownName;
    private NbtAddress unknownAddress;

    public NameServiceClientImpl(CIFSContext tc) {
        this(tc.getConfig().getNetbiosLocalPort(), tc.getConfig().getNetbiosLocalAddress(), tc);
    }

    NameServiceClientImpl(int lport, InetAddress laddr, CIFSContext tc) {
        this.lport = lport;
        this.laddr = laddr;
        this.transportContext = tc;
        this.baddr = tc.getConfig().getBroadcastAddress();
        this.snd_buf = new byte[tc.getConfig().getNetbiosSndBufSize()];
        this.rcv_buf = new byte[tc.getConfig().getNetbiosRcvBufSize()];
        this.out = new DatagramPacket(this.snd_buf, tc.getConfig().getNetbiosSndBufSize(), this.baddr, 137);
        this.in = new DatagramPacket(this.rcv_buf, tc.getConfig().getNetbiosRcvBufSize());
        this.resolveOrder = tc.getConfig().getResolveOrder();
        this.initCache(tc);
    }

    private void initCache(CIFSContext tc) {
        Object localHostname;
        this.unknownName = new Name(tc.getConfig(), "0.0.0.0", 0, null);
        this.unknownAddress = new NbtAddress(this.unknownName, 0, false, 0);
        this.addressCache.put(this.unknownName, new CacheEntry(this.unknownName, this.unknownAddress, -1L));
        InetAddress localInetAddress = tc.getConfig().getNetbiosLocalAddress();
        if (localInetAddress == null) {
            try {
                localInetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                try {
                    localInetAddress = InetAddress.getByName("127.0.0.1");
                }
                catch (UnknownHostException ignored) {
                    throw new RuntimeCIFSException(ignored);
                }
            }
        }
        if ((localHostname = tc.getConfig().getNetbiosHostname()) == null || ((String)localHostname).length() == 0) {
            byte[] addr = localInetAddress.getAddress();
            localHostname = "JCIFS" + (addr[2] & 0xFF) + "_" + (addr[3] & 0xFF) + "_" + Hexdump.toHexString((int)(Math.random() * 255.0), 2);
        }
        Name localName = new Name(tc.getConfig(), (String)localHostname, 0, tc.getConfig().getNetbiosScope());
        this.localhostAddress = new NbtAddress(localName, localInetAddress.hashCode(), false, 0, false, false, true, false, UNKNOWN_MAC_ADDRESS);
        this.cacheAddress(localName, this.localhostAddress, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NbtAddress doNameQuery(Name name, InetAddress svr) throws UnknownHostException {
        if (name.hexCode == 29 && svr == null) {
            svr = this.baddr;
        }
        name.srcHashCode = svr != null ? svr.hashCode() : 0;
        NbtAddress addr = this.getCachedAddress(name);
        if (addr == null && (addr = (NbtAddress)this.checkLookupTable(name)) == null) {
            try {
                addr = this.getByName(name, svr);
            }
            catch (UnknownHostException uhe) {
                addr = this.unknownAddress;
            }
            finally {
                this.cacheAddress(name, addr);
                this.updateLookupTable(name);
            }
        }
        if (addr == this.unknownAddress) {
            throw new UnknownHostException(name.toString());
        }
        return addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object checkLookupTable(Name name) {
        Set<Name> set = this.inFlightLookups;
        synchronized (set) {
            if (!this.inFlightLookups.contains(name)) {
                this.inFlightLookups.add(name);
                return null;
            }
            while (this.inFlightLookups.contains(name)) {
                try {
                    this.inFlightLookups.wait();
                }
                catch (InterruptedException e) {
                    log.trace("Interrupted", (Throwable)e);
                }
            }
        }
        NbtAddress obj = this.getCachedAddress(name);
        if (obj == null) {
            set = this.inFlightLookups;
            synchronized (set) {
                this.inFlightLookups.add(name);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLookupTable(Name name) {
        Set<Name> set = this.inFlightLookups;
        synchronized (set) {
            this.inFlightLookups.remove(name);
            this.inFlightLookups.notifyAll();
        }
    }

    void cacheAddress(Name hostName, NbtAddress addr) {
        if (this.transportContext.getConfig().getNetbiosCachePolicy() == 0) {
            return;
        }
        long expiration = -1L;
        if (this.transportContext.getConfig().getNetbiosCachePolicy() != -1) {
            expiration = System.currentTimeMillis() + (long)(this.transportContext.getConfig().getNetbiosCachePolicy() * 1000);
        }
        this.cacheAddress(hostName, addr, expiration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheAddress(Name hostName, NbtAddress addr, long expiration) {
        if (this.transportContext.getConfig().getNetbiosCachePolicy() == 0) {
            return;
        }
        Map<Name, CacheEntry> map = this.addressCache;
        synchronized (map) {
            CacheEntry entry = this.addressCache.get(hostName);
            if (entry == null) {
                entry = new CacheEntry(hostName, addr, expiration);
                this.addressCache.put(hostName, entry);
            } else {
                entry.address = addr;
                entry.expiration = expiration;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheAddressArray(NbtAddress[] addrs) {
        if (this.transportContext.getConfig().getNetbiosCachePolicy() == 0) {
            return;
        }
        long expiration = -1L;
        if (this.transportContext.getConfig().getNetbiosCachePolicy() != -1) {
            expiration = System.currentTimeMillis() + (long)(this.transportContext.getConfig().getNetbiosCachePolicy() * 1000);
        }
        Map<Name, CacheEntry> map = this.addressCache;
        synchronized (map) {
            for (NbtAddress addr : addrs) {
                CacheEntry entry = this.addressCache.get(addr.hostName);
                if (entry == null) {
                    entry = new CacheEntry(addr.hostName, addr, expiration);
                    this.addressCache.put(addr.hostName, entry);
                    continue;
                }
                entry.address = addr;
                entry.expiration = expiration;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NbtAddress getCachedAddress(Name hostName) {
        if (this.transportContext.getConfig().getNetbiosCachePolicy() == 0) {
            return null;
        }
        Map<Name, CacheEntry> map = this.addressCache;
        synchronized (map) {
            CacheEntry entry = this.addressCache.get(hostName);
            if (entry != null && entry.expiration < System.currentTimeMillis() && entry.expiration >= 0L) {
                entry = null;
            }
            return entry != null ? entry.address : null;
        }
    }

    int getNextNameTrnId() {
        if ((++this.nextNameTrnId & 0xFFFF) == 0) {
            this.nextNameTrnId = 1;
        }
        return this.nextNameTrnId;
    }

    void ensureOpen(int timeout) throws IOException {
        this.closeTimeout = 0;
        if (this.transportContext.getConfig().getNetbiosSoTimeout() != 0) {
            this.closeTimeout = Math.max(this.transportContext.getConfig().getNetbiosSoTimeout(), timeout);
        }
        if (this.socket == null) {
            this.socket = new DatagramSocket(this.lport, this.laddr);
            this.thread = new Thread((Runnable)this, "JCIFS-NameServiceClient");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryClose() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
            this.thread = null;
            this.responseTable.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (this.thread == Thread.currentThread()) {
                this.in.setLength(this.transportContext.getConfig().getNetbiosRcvBufSize());
                this.socket.setSoTimeout(this.closeTimeout);
                this.socket.receive(this.in);
                log.trace("NetBIOS: new data read from socket");
                int nameTrnId = NameServicePacket.readNameTrnId(this.rcv_buf, 0);
                NameServicePacket response = this.responseTable.get(nameTrnId);
                if (response == null || response.received) continue;
                NameServicePacket nameServicePacket = response;
                synchronized (nameServicePacket) {
                    response.readWireFormat(this.rcv_buf, 0);
                    response.received = true;
                    if (log.isTraceEnabled()) {
                        log.trace(response.toString());
                        log.trace(Hexdump.toHexString(this.rcv_buf, 0, this.in.getLength()));
                    }
                    response.notify();
                }
            }
            return;
        }
        catch (SocketTimeoutException ste) {
            log.trace("Socket timeout", (Throwable)ste);
            return;
        }
        catch (Exception ex) {
            log.warn("Uncaught exception in NameServiceClient", (Throwable)ex);
            return;
        }
        finally {
            this.tryClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void send(NameServicePacket request, NameServicePacket response, int timeout) throws IOException {
        nid = null;
        max = this.transportContext.getConfig().getWinsServers().length;
        if (max == 0) {
            max = 1;
        }
        var6_6 = response;
        synchronized (var6_6) {
            while (max-- > 0) {
                block19: {
                    block18: {
                        try {
                            var7_7 = this.LOCK;
                            synchronized (var7_7) {
                                request.nameTrnId = this.getNextNameTrnId();
                                nid = request.nameTrnId;
                                this.out.setAddress(request.addr);
                                this.out.setLength(request.writeWireFormat(this.snd_buf, 0));
                                response.received = false;
                                this.responseTable.put(nid, response);
                                this.ensureOpen(timeout + 1000);
                                this.socket.send(this.out);
                                if (NameServiceClientImpl.log.isTraceEnabled()) {
                                    NameServiceClientImpl.log.trace(request.toString());
                                    NameServiceClientImpl.log.trace(Hexdump.toHexString(this.snd_buf, 0, this.out.getLength()));
                                }
                            }
                            start = System.currentTimeMillis();
lbl24:
                            // 2 sources

                            while (timeout > 0) {
                                response.wait(timeout);
                                if (response.received && request.questionType == response.recordType) {
                                    this.responseTable.remove(nid);
                                    break block18;
                                }
                                ** GOTO lbl-1000
                            }
                            break block19;
                        }
                        catch (InterruptedException ie) {
                            try {
                                throw new InterruptedIOException();
                            }
                            catch (Throwable var9_10) {
                                this.responseTable.remove(nid);
                                throw var9_10;
                            }
                        }
                    }
                    return;
lbl-1000:
                    // 1 sources

                    {
                        response.received = false;
                        timeout = (int)((long)timeout - (System.currentTimeMillis() - start));
                        ** GOTO lbl24
                    }
                }
                this.responseTable.remove(nid);
                var7_7 = this.LOCK;
                synchronized (var7_7) {
                    if (!this.isWINS(request.addr)) {
                        return;
                    }
                    if (request.addr == this.getWINSAddress()) {
                        this.switchWINS();
                    }
                    request.addr = this.getWINSAddress();
                }
            }
            return;
        }
    }

    NbtAddress[] getAllByName(Name name, InetAddress addr) throws UnknownHostException {
        int n;
        Configuration config = this.transportContext.getConfig();
        NameQueryRequest request = new NameQueryRequest(config, name);
        NameQueryResponse response = new NameQueryResponse(config);
        request.addr = addr != null ? addr : this.getWINSAddress();
        boolean bl = request.isBroadcast = request.addr == null || this.isBroadcastAddress(request.addr);
        if (request.isBroadcast) {
            if (request.addr == null) {
                request.addr = this.baddr;
            }
            n = config.getNetbiosRetryCount();
        } else {
            n = 1;
        }
        do {
            try {
                this.send(request, response, config.getNetbiosRetryTimeout());
            }
            catch (InterruptedIOException ioe) {
                if (log.isTraceEnabled()) {
                    log.trace("Failed to send nameservice request for " + name.name, (Throwable)ioe);
                }
                throw new UnknownHostException(name.name);
            }
            catch (IOException ioe) {
                log.info("Failed to send nameservice request for " + name.name, (Throwable)ioe);
                throw new UnknownHostException(name.name);
            }
            if (!response.received || response.resultCode != 0) continue;
            return response.addrEntry;
        } while (--n > 0 && request.isBroadcast);
        throw new UnknownHostException(name.name);
    }

    NbtAddress getByName(Name name, InetAddress addr) throws UnknownHostException {
        NameQueryRequest request = new NameQueryRequest(this.transportContext.getConfig(), name);
        NameQueryResponse response = new NameQueryResponse(this.transportContext.getConfig());
        if (addr != null) {
            request.addr = addr;
            request.isBroadcast = this.isBroadcastAddress(addr);
            int n = this.transportContext.getConfig().getNetbiosRetryCount();
            do {
                try {
                    this.send(request, response, this.transportContext.getConfig().getNetbiosRetryTimeout());
                }
                catch (InterruptedIOException ioe) {
                    if (log.isTraceEnabled()) {
                        log.trace("Timeout waiting for response " + name.name, (Throwable)ioe);
                    }
                    throw new UnknownHostException(name.name);
                }
                catch (IOException ioe) {
                    log.info("Failed to send nameservice request for " + name.name, (Throwable)ioe);
                    throw new UnknownHostException(name.name);
                }
                if (!response.received || response.resultCode != 0) continue;
                int last = response.addrEntry.length - 1;
                response.addrEntry[last].hostName.srcHashCode = addr.hashCode();
                return response.addrEntry[last];
            } while (--n > 0 && request.isBroadcast);
            throw new UnknownHostException(name.name);
        }
        for (ResolverType resolverType : this.resolveOrder) {
            try {
                block3 : switch (resolverType) {
                    case RESOLVER_LMHOSTS: {
                        NbtAddress ans = this.lmhosts.getByName(name, this.transportContext);
                        if (ans == null) break;
                        ans.hostName.srcHashCode = 0;
                        return ans;
                    }
                    case RESOLVER_WINS: 
                    case RESOLVER_BCAST: {
                        if (resolverType == ResolverType.RESOLVER_WINS && name.name != "\u0001\u0002__MSBROWSE__\u0002" && name.hexCode != 29) {
                            request.addr = this.getWINSAddress();
                            request.isBroadcast = false;
                        } else {
                            request.addr = this.baddr;
                            request.isBroadcast = true;
                        }
                        int n = this.transportContext.getConfig().getNetbiosRetryCount();
                        while (n-- > 0) {
                            try {
                                this.send(request, response, this.transportContext.getConfig().getNetbiosRetryTimeout());
                            }
                            catch (IOException ioe) {
                                log.info("Failed to send nameservice request for " + name.name, (Throwable)ioe);
                                throw new UnknownHostException(name.name);
                            }
                            if (response.received && response.resultCode == 0) {
                                response.addrEntry[0].hostName.srcHashCode = request.addr.hashCode();
                                return response.addrEntry[0];
                            }
                            if (resolverType != ResolverType.RESOLVER_WINS) continue;
                            break block3;
                        }
                        break;
                    }
                }
            }
            catch (IOException ioe) {
                log.debug("Failed to lookup name", (Throwable)ioe);
            }
        }
        throw new UnknownHostException(name.name);
    }

    public NbtAddress[] getNodeStatus(NetbiosAddress addr) throws UnknownHostException {
        NodeStatusResponse response = new NodeStatusResponse(this.transportContext.getConfig(), addr.unwrap(NbtAddress.class));
        NodeStatusRequest request = new NodeStatusRequest(this.transportContext.getConfig(), new Name(this.transportContext.getConfig(), "*\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", 0, null));
        request.addr = addr.toInetAddress();
        int n = this.transportContext.getConfig().getNetbiosRetryCount();
        while (n-- > 0) {
            try {
                this.send(request, response, this.transportContext.getConfig().getNetbiosRetryTimeout());
            }
            catch (IOException ioe) {
                log.info("Failed to send node status request for " + String.valueOf(addr), (Throwable)ioe);
                throw new UnknownHostException(addr.toString());
            }
            if (!response.received || response.resultCode != 0) continue;
            int srcHashCode = request.addr.hashCode();
            for (int i = 0; i < response.addressArray.length; ++i) {
                response.addressArray[i].hostName.srcHashCode = srcHashCode;
            }
            return response.addressArray;
        }
        throw new UnknownHostException(addr.getHostName());
    }

    @Override
    public NbtAddress getNbtByName(String host) throws UnknownHostException {
        return this.getNbtByName(host, 0, null);
    }

    @Override
    public NbtAddress getNbtByName(String host, int type, String scope) throws UnknownHostException {
        return this.getNbtByName(host, type, scope, null);
    }

    @Override
    public NbtAddress getNbtByName(String host, int type, String scope, InetAddress svr) throws UnknownHostException {
        if (host == null || host.length() == 0) {
            return this.getLocalHost();
        }
        Name name = new Name(this.transportContext.getConfig(), host, type, scope);
        if (!Character.isDigit(host.charAt(0))) {
            return this.doNameQuery(name, svr);
        }
        int IP = 0;
        int hitDots = 0;
        char[] data = host.toCharArray();
        for (int i = 0; i < data.length; ++i) {
            char c = data[i];
            if (c < '0' || c > '9') {
                return this.doNameQuery(name, svr);
            }
            int b = 0;
            while (c != '.') {
                if (c < '0' || c > '9') {
                    return this.doNameQuery(name, svr);
                }
                b = b * 10 + c - 48;
                if (++i >= data.length) break;
                c = data[i];
            }
            if (b > 255) {
                return this.doNameQuery(name, svr);
            }
            IP = (IP << 8) + b;
            ++hitDots;
        }
        if (hitDots != 4 || host.endsWith(".")) {
            return this.doNameQuery(name, svr);
        }
        return new NbtAddress(this.getUnknownName(), IP, false, 0);
    }

    public NbtAddress[] getNbtAllByName(String host, int type, String scope, InetAddress svr) throws UnknownHostException {
        return this.getAllByName(new Name(this.transportContext.getConfig(), host, type, scope), svr);
    }

    public NbtAddress[] getNbtAllByAddress(String host) throws UnknownHostException {
        return this.getNbtAllByAddress(this.getNbtByName(host, 0, null));
    }

    public NbtAddress[] getNbtAllByAddress(String host, int type, String scope) throws UnknownHostException {
        return this.getNbtAllByAddress(this.getNbtByName(host, type, scope));
    }

    public NbtAddress[] getNbtAllByAddress(NetbiosAddress addr) throws UnknownHostException {
        try {
            NbtAddress[] addrs = this.getNodeStatus(addr);
            this.cacheAddressArray(addrs);
            return addrs;
        }
        catch (UnknownHostException uhe) {
            throw new UnknownHostException("no name with type 0x" + Hexdump.toHexString(addr.getNameType(), 2) + (String)(addr.getName().getScope() == null || addr.getName().getScope().isEmpty() ? " with no scope" : " with scope " + addr.getName().getScope()) + " for host " + addr.getHostAddress());
        }
    }

    protected InetAddress getWINSAddress() {
        return this.transportContext.getConfig().getWinsServers().length == 0 ? null : this.transportContext.getConfig().getWinsServers()[this.nbnsIndex];
    }

    protected boolean isWINS(InetAddress svr) {
        for (int i = 0; svr != null && i < this.transportContext.getConfig().getWinsServers().length; ++i) {
            if (svr.hashCode() != this.transportContext.getConfig().getWinsServers()[i].hashCode()) continue;
            return true;
        }
        return false;
    }

    private boolean isBroadcastAddress(InetAddress svr) {
        return svr.equals(this.baddr) || svr.getAddress()[3] == -1;
    }

    protected InetAddress switchWINS() {
        this.nbnsIndex = this.nbnsIndex + 1 < this.transportContext.getConfig().getWinsServers().length ? this.nbnsIndex + 1 : 0;
        return this.transportContext.getConfig().getWinsServers().length == 0 ? null : this.transportContext.getConfig().getWinsServers()[this.nbnsIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NetbiosAddress[] lookupServerOrWorkgroup(String name, InetAddress svr) throws UnknownHostException {
        Sem sem = new Sem(2);
        int type = this.isWINS(svr) ? 27 : 29;
        QueryThread q1x = new QueryThread(sem, name, type, null, svr, this.transportContext);
        QueryThread q20 = new QueryThread(sem, name, 32, null, svr, this.transportContext);
        q1x.setDaemon(true);
        q20.setDaemon(true);
        try {
            Sem sem2 = sem;
            synchronized (sem2) {
                q1x.start();
                q20.start();
                while (sem.count > 0 && q1x.getAnswer() == null && q20.getAnswer() == null) {
                    sem.wait();
                }
            }
        }
        catch (InterruptedException ie) {
            throw new UnknownHostException(name);
        }
        NameServiceClientImpl.waitForQueryThreads(q1x, q20);
        if (q1x.getAnswer() != null) {
            return q1x.getAnswer();
        }
        if (q20.getAnswer() != null) {
            return q20.getAnswer();
        }
        throw q1x.getException();
    }

    private static void waitForQueryThreads(QueryThread q1x, QueryThread q20) {
        NameServiceClientImpl.interruptThreadSafely(q1x);
        NameServiceClientImpl.joinThread(q1x);
        NameServiceClientImpl.interruptThreadSafely(q20);
        NameServiceClientImpl.joinThread(q20);
    }

    private static void interruptThreadSafely(QueryThread thread) {
        try {
            thread.interrupt();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    private static void joinThread(Thread thread) {
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static boolean isAllDigits(String hostname) {
        for (int i = 0; i < hostname.length(); ++i) {
            if (Character.isDigit(hostname.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public UniAddress getByName(String hostname) throws UnknownHostException {
        return this.getByName(hostname, false);
    }

    @Override
    public UniAddress getByName(String hostname, boolean possibleNTDomainOrWorkgroup) throws UnknownHostException {
        return this.getAllByName(hostname, possibleNTDomainOrWorkgroup)[0];
    }

    public UniAddress[] getAllByName(String hostname, boolean possibleNTDomainOrWorkgroup) throws UnknownHostException {
        if (hostname == null || hostname.length() == 0) {
            throw new UnknownHostException();
        }
        if (UniAddress.isDotQuadIP(hostname)) {
            return new UniAddress[]{new UniAddress(this.getNbtByName(hostname))};
        }
        if (log.isTraceEnabled()) {
            log.trace("Resolver order is " + String.valueOf(this.transportContext.getConfig().getResolveOrder()));
        }
        block8: for (ResolverType resolver : this.transportContext.getConfig().getResolveOrder()) {
            Object[] addr = null;
            try {
                switch (resolver) {
                    case RESOLVER_LMHOSTS: {
                        NbtAddress lmaddr = this.getLmhosts().getByName(hostname, this.transportContext);
                        if (lmaddr == null) continue block8;
                        addr = new NetbiosAddress[]{lmaddr};
                        break;
                    }
                    case RESOLVER_WINS: {
                        if (hostname.equals("\u0001\u0002__MSBROWSE__\u0002") || hostname.length() > 15) continue block8;
                        if (possibleNTDomainOrWorkgroup) {
                            addr = this.lookupServerOrWorkgroup(hostname, this.getWINSAddress());
                            break;
                        }
                        addr = this.getNbtAllByName(hostname, 32, null, this.getWINSAddress());
                        break;
                    }
                    case RESOLVER_BCAST: {
                        if (hostname.length() > 15) continue block8;
                        if (possibleNTDomainOrWorkgroup) {
                            addr = this.lookupServerOrWorkgroup(hostname, this.transportContext.getConfig().getBroadcastAddress());
                            break;
                        }
                        addr = this.getNbtAllByName(hostname, 32, null, this.transportContext.getConfig().getBroadcastAddress());
                        break;
                    }
                    case RESOLVER_DNS: {
                        if (NameServiceClientImpl.isAllDigits(hostname)) {
                            throw new UnknownHostException(hostname);
                        }
                        Object[] addrs = NameServiceClientImpl.wrapInetAddresses(InetAddress.getAllByName(hostname));
                        if (log.isDebugEnabled()) {
                            log.debug("Resolved '{}' to {} using DNS", (Object)hostname, (Object)Arrays.toString(addrs));
                        }
                        return addrs;
                    }
                    default: {
                        throw new UnknownHostException(hostname);
                    }
                }
                if (addr == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Resolved '{}' to addrs {} via {}", new Object[]{hostname, Arrays.toString(addr), resolver});
                }
                return NameServiceClientImpl.wrapNetbiosAddresses((NetbiosAddress[])addr);
            }
            catch (IOException ioe) {
                log.trace("Resolving {} via {} failed:", (Object)hostname, (Object)resolver);
                log.trace("Exception is", (Throwable)ioe);
            }
        }
        throw new UnknownHostException(hostname);
    }

    private static UniAddress[] wrapInetAddresses(InetAddress[] iaddrs) {
        UniAddress[] addrs = new UniAddress[iaddrs.length];
        for (int ii = 0; ii < iaddrs.length; ++ii) {
            addrs[ii] = new UniAddress(iaddrs[ii]);
        }
        return addrs;
    }

    private static UniAddress[] wrapNetbiosAddresses(NetbiosAddress[] addr) {
        UniAddress[] addrs = new UniAddress[addr.length];
        for (int i = 0; i < addr.length; ++i) {
            addrs[i] = new UniAddress(addr[i]);
        }
        return addrs;
    }

    @Override
    public NbtAddress getLocalHost() {
        return this.localhostAddress;
    }

    @Override
    public Name getLocalName() {
        if (this.localhostAddress != null) {
            return this.localhostAddress.hostName;
        }
        return null;
    }

    public Lmhosts getLmhosts() {
        return this.lmhosts;
    }

    @Override
    public Name getUnknownName() {
        return this.unknownName;
    }

    static final class CacheEntry {
        Name hostName;
        NbtAddress address;
        long expiration;

        CacheEntry(Name hostName, NbtAddress address, long expiration) {
            this.hostName = hostName;
            this.address = address;
            this.expiration = expiration;
        }
    }

    static class Sem {
        int count;

        Sem(int count) {
            this.count = count;
        }
    }

    static class QueryThread
    extends Thread {
        private final Sem sem;
        private final String host;
        private final String scope;
        private final int type;
        private NetbiosAddress[] ans = null;
        private final InetAddress svr;
        private UnknownHostException uhe;
        private final CIFSContext tc;

        QueryThread(Sem sem, String host, int type, String scope, InetAddress svr, CIFSContext tc) {
            super("JCIFS-QueryThread: " + host);
            this.sem = sem;
            this.host = host;
            this.type = type;
            this.scope = scope;
            this.svr = svr;
            this.tc = tc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.ans = this.tc.getNameServiceClient().getNbtAllByName(this.host, this.type, this.scope, this.svr);
            }
            catch (UnknownHostException ex) {
                this.uhe = ex;
            }
            catch (Exception ex) {
                this.uhe = new UnknownHostException(ex.getMessage());
            }
            finally {
                Sem ex = this.sem;
                synchronized (ex) {
                    --this.sem.count;
                    this.sem.notify();
                }
            }
        }

        public NetbiosAddress[] getAnswer() {
            return this.ans;
        }

        public UnknownHostException getException() {
            return this.uhe;
        }
    }
}

