/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb2.create;

import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.SMBProtocolDecodingException;
import org.codelibs.jcifs.smb.internal.SmbBasicFileInfo;
import org.codelibs.jcifs.smb.internal.smb2.ServerMessageBlock2Response;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;
import org.codelibs.jcifs.smb.util.Hexdump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Smb2CloseResponse
extends ServerMessageBlock2Response
implements SmbBasicFileInfo {
    private static final Logger log = LoggerFactory.getLogger(Smb2CloseResponse.class);
    public static final int SMB2_CLOSE_FLAG_POSTQUERY_ATTIB = 1;
    private final byte[] fileId;
    private final String fileName;
    private int closeFlags;
    private long creationTime;
    private long lastAccessTime;
    private long lastWriteTime;
    private long changeTime;
    private long allocationSize;
    private long endOfFile;
    private int fileAttributes;

    public Smb2CloseResponse(Configuration config, byte[] fileId, String fileName) {
        super(config);
        this.fileId = fileId;
        this.fileName = fileName;
    }

    public final int getCloseFlags() {
        return this.closeFlags;
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public final long getCreateTime() {
        return this.getCreationTime();
    }

    @Override
    public final long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public final long getLastWriteTime() {
        return this.lastWriteTime;
    }

    public final long getChangeTime() {
        return this.changeTime;
    }

    public final long getAllocationSize() {
        return this.allocationSize;
    }

    public final long getEndOfFile() {
        return this.endOfFile;
    }

    public byte[] getFileId() {
        return this.fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public long getSize() {
        return this.getEndOfFile();
    }

    public int getFileAttributes() {
        return this.fileAttributes;
    }

    @Override
    public int getAttributes() {
        return this.getFileAttributes();
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        int structureSize = SMBUtil.readInt2(buffer, bufferIndex);
        if (structureSize != 60) {
            throw new SMBProtocolDecodingException("Expected structureSize = 60");
        }
        this.closeFlags = SMBUtil.readInt2(buffer, bufferIndex + 2);
        bufferIndex += 4;
        this.creationTime = SMBUtil.readTime(buffer, bufferIndex += 4);
        this.lastAccessTime = SMBUtil.readTime(buffer, bufferIndex += 8);
        this.lastWriteTime = SMBUtil.readTime(buffer, bufferIndex += 8);
        this.changeTime = SMBUtil.readTime(buffer, bufferIndex += 8);
        this.allocationSize = SMBUtil.readInt8(buffer, bufferIndex += 8);
        this.endOfFile = SMBUtil.readInt8(buffer, bufferIndex += 8);
        this.fileAttributes = SMBUtil.readInt4(buffer, bufferIndex += 8);
        bufferIndex += 4;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Closed %s (%s)", Hexdump.toHexString(this.fileId), this.fileName));
        }
        return bufferIndex - start;
    }
}

