/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb2.create;

import org.codelibs.jcifs.smb.CIFSContext;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.smb2.RequestWithFileId;
import org.codelibs.jcifs.smb.internal.smb2.ServerMessageBlock2Request;
import org.codelibs.jcifs.smb.internal.smb2.Smb2Constants;
import org.codelibs.jcifs.smb.internal.smb2.create.Smb2CloseResponse;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;
import org.codelibs.jcifs.smb.util.Hexdump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Smb2CloseRequest
extends ServerMessageBlock2Request<Smb2CloseResponse>
implements RequestWithFileId {
    private static final Logger log = LoggerFactory.getLogger(Smb2CloseRequest.class);
    private byte[] fileId;
    private final String fileName;
    private int closeFlags;

    public Smb2CloseRequest(Configuration config, byte[] fileId, String fileName) {
        super(config, 6);
        this.fileId = fileId;
        this.fileName = fileName;
    }

    public Smb2CloseRequest(Configuration config, byte[] fileId) {
        this(config, fileId, "");
    }

    @Override
    public void setFileId(byte[] fileId) {
        this.fileId = fileId;
    }

    public Smb2CloseRequest(Configuration config, String fileName) {
        this(config, Smb2Constants.UNSPECIFIED_FILEID, fileName);
    }

    @Override
    protected Smb2CloseResponse createResponse(CIFSContext tc, ServerMessageBlock2Request<Smb2CloseResponse> req) {
        return new Smb2CloseResponse(tc.getConfig(), this.fileId, this.fileName);
    }

    public void setCloseFlags(int flags) {
        this.closeFlags = flags;
    }

    @Override
    public int size() {
        return Smb2CloseRequest.size8(88);
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(24L, dst, dstIndex);
        SMBUtil.writeInt2(this.closeFlags, dst, dstIndex + 2);
        dstIndex += 4;
        System.arraycopy(this.fileId, 0, dst, dstIndex += 4, 16);
        dstIndex += 16;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Closing %s (%s)", Hexdump.toHexString(this.fileId), this.fileName));
        }
        return dstIndex - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }
}

