/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.trans2;

import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.dfs.DfsReferralRequestBuffer;
import org.codelibs.jcifs.smb.internal.smb1.trans.SmbComTransaction;

public class Trans2GetDfsReferral
extends SmbComTransaction {
    private final int maxReferralLevel;
    private final DfsReferralRequestBuffer request;

    public Trans2GetDfsReferral(Configuration config, String filename) {
        this(config, filename, 3);
    }

    public Trans2GetDfsReferral(Configuration config, String filename, int maxReferralLevel) {
        super(config, (byte)50, (byte)16);
        this.maxReferralLevel = maxReferralLevel;
        this.request = new DfsReferralRequestBuffer(filename, maxReferralLevel);
        this.totalDataCount = 0;
        this.maxParameterCount = 0;
        this.maxDataCount = 4096;
        this.maxSetupCount = 0;
    }

    @Override
    public boolean isForceUnicode() {
        return true;
    }

    @Override
    protected int writeSetupWireFormat(byte[] dst, int dstIndex) {
        dst[dstIndex] = this.getSubCommand();
        int n = ++dstIndex;
        ++dstIndex;
        dst[n] = 0;
        return 2;
    }

    @Override
    protected int writeParametersWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        dstIndex += this.request.encode(dst, dstIndex);
        return dstIndex - start;
    }

    @Override
    protected int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    public String toString() {
        return "Trans2GetDfsReferral[" + super.toString() + ",maxReferralLevel=0x" + this.maxReferralLevel + ",filename=" + this.path + "]";
    }
}

