/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.trans2;

import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.smb1.trans.SmbComTransaction;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;
import org.codelibs.jcifs.smb.util.Hexdump;

public class Trans2FindNext2
extends SmbComTransaction {
    private final int sid;
    private final int informationLevel;
    private int resumeKey;
    private final int tflags;
    private String filename;
    private final long maxItems;

    public Trans2FindNext2(Configuration config, int sid, int resumeKey, String filename, int batchCount, int batchSize) {
        super(config, (byte)50, (byte)2);
        this.sid = sid;
        this.resumeKey = resumeKey;
        this.filename = filename;
        this.informationLevel = 260;
        this.tflags = 0;
        this.maxParameterCount = 8;
        this.maxItems = batchCount;
        this.maxDataCount = batchSize;
        this.maxSetupCount = 0;
    }

    @Override
    public void reset(int rk, String lastName) {
        super.reset();
        this.resumeKey = rk;
        this.filename = lastName;
        this.flags2 = 0;
    }

    @Override
    protected int writeSetupWireFormat(byte[] dst, int dstIndex) {
        dst[dstIndex] = this.getSubCommand();
        int n = ++dstIndex;
        ++dstIndex;
        dst[n] = 0;
        return 2;
    }

    @Override
    protected int writeParametersWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(this.sid, dst, dstIndex);
        SMBUtil.writeInt2(this.maxItems, dst, dstIndex += 2);
        SMBUtil.writeInt2(this.informationLevel, dst, dstIndex += 2);
        SMBUtil.writeInt4(this.resumeKey, dst, dstIndex += 2);
        SMBUtil.writeInt2(this.tflags, dst, dstIndex += 4);
        dstIndex += 2;
        dstIndex += this.writeString(this.filename, dst, dstIndex);
        return dstIndex - start;
    }

    @Override
    protected int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    public String toString() {
        return "Trans2FindNext2[" + super.toString() + ",sid=" + this.sid + ",searchCount=" + this.getConfig().getListSize() + ",informationLevel=0x" + Hexdump.toHexString(this.informationLevel, 3) + ",resumeKey=0x" + Hexdump.toHexString(this.resumeKey, 4) + ",flags=0x" + Hexdump.toHexString(this.tflags, 2) + ",filename=" + this.filename + "]";
    }
}

