/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.trans;

import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.smb1.trans.SmbComTransaction;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransTransactNamedPipe
extends SmbComTransaction {
    private static final Logger log = LoggerFactory.getLogger(TransTransactNamedPipe.class);
    private final byte[] pipeData;
    private final int pipeFid;
    private final int pipeDataOff;
    private final int pipeDataLen;

    public TransTransactNamedPipe(Configuration config, int fid, byte[] data, int off, int len) {
        super(config, (byte)37, (byte)38);
        this.pipeFid = fid;
        this.pipeData = data;
        this.pipeDataOff = off;
        this.pipeDataLen = len;
        this.maxParameterCount = 0;
        this.maxDataCount = 65535;
        this.maxSetupCount = 0;
        this.setupCount = 2;
        this.name = "\\PIPE\\";
    }

    @Override
    protected int writeSetupWireFormat(byte[] dst, int dstIndex) {
        dst[dstIndex] = this.getSubCommand();
        int n = ++dstIndex;
        dst[n] = 0;
        SMBUtil.writeInt2(this.pipeFid, dst, ++dstIndex);
        dstIndex += 2;
        return 4;
    }

    @Override
    protected int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int writeParametersWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeDataWireFormat(byte[] dst, int dstIndex) {
        if (dst.length - dstIndex < this.pipeDataLen) {
            log.debug("TransTransactNamedPipe data too long for buffer");
            return 0;
        }
        System.arraycopy(this.pipeData, this.pipeDataOff, dst, dstIndex, this.pipeDataLen);
        return this.pipeDataLen;
    }

    @Override
    protected int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    public String toString() {
        return "TransTransactNamedPipe[" + super.toString() + ",pipeFid=" + this.pipeFid + "]";
    }
}

