/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.com;

import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.smb1.AndXServerMessageBlock;
import org.codelibs.jcifs.smb.internal.smb1.ServerMessageBlock;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class SmbComWriteAndX
extends AndXServerMessageBlock {
    private int fid;
    private int remaining;
    private int dataLength;
    private int dataOffset;
    private int off;
    private byte[] b;
    private long offset;
    private int pad;
    private int writeMode;

    public SmbComWriteAndX(Configuration config) {
        super(config, (byte)47, (ServerMessageBlock)null);
    }

    public SmbComWriteAndX(Configuration config, int fid, long offset, int remaining, byte[] b, int off, int len, ServerMessageBlock andx) {
        super(config, (byte)47, andx);
        this.fid = fid;
        this.offset = offset;
        this.remaining = remaining;
        this.b = b;
        this.off = off;
        this.dataLength = len;
    }

    public final void setParam(int fid, long offset, int remaining, byte[] b, int off, int len) {
        this.fid = fid;
        this.offset = offset;
        this.remaining = remaining;
        this.b = b;
        this.off = off;
        this.dataLength = len;
        this.digest = null;
    }

    public final void setWriteMode(int writeMode) {
        this.writeMode = writeMode;
    }

    @Override
    protected int getBatchLimit(Configuration cfg, byte cmd) {
        if (cmd == 46) {
            return cfg.getBatchLimit("WriteAndX.ReadAndX");
        }
        if (cmd == 4) {
            return cfg.getBatchLimit("WriteAndX.Close");
        }
        return 0;
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        this.dataOffset = dstIndex - this.headerStart + 26;
        this.pad = (this.dataOffset - this.headerStart) % 4;
        this.pad = this.pad == 0 ? 0 : 4 - this.pad;
        this.dataOffset += this.pad;
        SMBUtil.writeInt2(this.fid, dst, dstIndex);
        SMBUtil.writeInt4(this.offset, dst, dstIndex += 2);
        dstIndex += 4;
        for (int i = 0; i < 4; ++i) {
            dst[dstIndex++] = -1;
        }
        SMBUtil.writeInt2(this.writeMode, dst, dstIndex);
        SMBUtil.writeInt2(this.remaining, dst, dstIndex += 2);
        dst[dstIndex += 2] = 0;
        int n = ++dstIndex;
        dst[n] = 0;
        SMBUtil.writeInt2(this.dataLength, dst, ++dstIndex);
        SMBUtil.writeInt2(this.dataOffset, dst, dstIndex += 2);
        SMBUtil.writeInt4(this.offset >> 32, dst, dstIndex += 2);
        return (dstIndex += 4) - start;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        while (this.pad-- > 0) {
            dst[dstIndex] = -18;
            ++dstIndex;
        }
        System.arraycopy(this.b, this.off, dst, dstIndex, this.dataLength);
        return (dstIndex += this.dataLength) - start;
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return "SmbComWriteAndX[" + super.toString() + ",fid=" + this.fid + ",offset=" + this.offset + ",writeMode=" + this.writeMode + ",remaining=" + this.remaining + ",dataLength=" + this.dataLength + ",dataOffset=" + this.dataOffset + "]";
    }
}

