/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.com;

import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.smb1.AndXServerMessageBlock;
import org.codelibs.jcifs.smb.internal.smb1.ServerMessageBlock;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class SmbComSessionSetupAndXResponse
extends AndXServerMessageBlock {
    private String nativeOs = "";
    private String nativeLanMan = "";
    private String primaryDomain = "";
    private boolean isLoggedInAsGuest;
    private byte[] blob = null;

    public SmbComSessionSetupAndXResponse(Configuration config, ServerMessageBlock andx) {
        super(config, andx);
    }

    public final String getNativeLanMan() {
        return this.nativeLanMan;
    }

    public final String getNativeOs() {
        return this.nativeOs;
    }

    public final String getPrimaryDomain() {
        return this.primaryDomain;
    }

    public final boolean isLoggedInAsGuest() {
        return this.isLoggedInAsGuest;
    }

    public final byte[] getBlob() {
        return this.blob;
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        this.isLoggedInAsGuest = (buffer[bufferIndex] & 1) == 1;
        bufferIndex += 2;
        if (this.isExtendedSecurity()) {
            int blobLength = SMBUtil.readInt2(buffer, bufferIndex);
            bufferIndex += 2;
            this.blob = new byte[blobLength];
        }
        return bufferIndex - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        if (this.isExtendedSecurity()) {
            System.arraycopy(buffer, bufferIndex, this.blob, 0, this.blob.length);
            bufferIndex += this.blob.length;
        }
        this.nativeOs = this.readString(buffer, bufferIndex);
        bufferIndex += this.stringWireLength(this.nativeOs, bufferIndex);
        this.nativeLanMan = this.readString(buffer, bufferIndex, start + this.byteCount, 255, this.isUseUnicode());
        bufferIndex += this.stringWireLength(this.nativeLanMan, bufferIndex);
        if (!this.isExtendedSecurity()) {
            this.primaryDomain = this.readString(buffer, bufferIndex, start + this.byteCount, 255, this.isUseUnicode());
            bufferIndex += this.stringWireLength(this.primaryDomain, bufferIndex);
        }
        return bufferIndex - start;
    }

    @Override
    public String toString() {
        return "SmbComSessionSetupAndXResponse[" + super.toString() + ",isLoggedInAsGuest=" + this.isLoggedInAsGuest + ",nativeOs=" + this.nativeOs + ",nativeLanMan=" + this.nativeLanMan + ",primaryDomain=" + this.primaryDomain + "]";
    }
}

