/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.com;

import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.smb1.AndXServerMessageBlock;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class SmbComReadAndXResponse
extends AndXServerMessageBlock {
    private byte[] data;
    private int offset;
    private int dataCompactionMode;
    private int dataLength;
    private int dataOffset;

    public SmbComReadAndXResponse(Configuration config) {
        super(config);
    }

    public SmbComReadAndXResponse(Configuration config, byte[] b, int off) {
        super(config);
        this.data = b;
        this.offset = off;
    }

    void setParam(byte[] b, int off) {
        this.data = b;
        this.offset = off;
    }

    public final byte[] getData() {
        return this.data;
    }

    public final int getOffset() {
        return this.offset;
    }

    public void adjustOffset(int n) {
        this.offset += n;
    }

    public final int getDataLength() {
        return this.dataLength;
    }

    public final int getDataOffset() {
        return this.dataOffset;
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        this.dataCompactionMode = SMBUtil.readInt2(buffer, bufferIndex += 2);
        this.dataLength = SMBUtil.readInt2(buffer, bufferIndex += 4);
        this.dataOffset = SMBUtil.readInt2(buffer, bufferIndex += 2);
        return (bufferIndex += 12) - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return "SmbComReadAndXResponse[" + super.toString() + ",dataCompactionMode=" + this.dataCompactionMode + ",dataLength=" + this.dataLength + ",dataOffset=" + this.dataOffset + "]";
    }
}

