/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.com;

import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.smb1.AndXServerMessageBlock;
import org.codelibs.jcifs.smb.internal.smb1.ServerMessageBlock;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class SmbComReadAndX
extends AndXServerMessageBlock {
    private long offset;
    private int fid;
    int openTimeout;
    int maxCount;
    int minCount;
    int remaining;

    public SmbComReadAndX(Configuration config) {
        super(config, (byte)46);
        this.openTimeout = -1;
    }

    public SmbComReadAndX(Configuration config, int fid, long offset, int maxCount, ServerMessageBlock andx) {
        super(config, (byte)46, andx);
        this.fid = fid;
        this.offset = offset;
        this.maxCount = this.minCount = maxCount;
        this.openTimeout = -1;
    }

    public final int getMaxCount() {
        return this.maxCount;
    }

    public final void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public final int getMinCount() {
        return this.minCount;
    }

    public final void setMinCount(int minCount) {
        this.minCount = minCount;
    }

    public final int getRemaining() {
        return this.remaining;
    }

    public final void setOpenTimeout(int openTimeout) {
        this.openTimeout = openTimeout;
    }

    public final void setRemaining(int remaining) {
        this.remaining = remaining;
    }

    void setParam(int fid, long offset, int maxCount) {
        this.fid = fid;
        this.offset = offset;
        this.maxCount = this.minCount = maxCount;
    }

    @Override
    protected int getBatchLimit(Configuration cfg, byte cmd) {
        return cmd == 4 ? cfg.getBatchLimit("ReadAndX.Close") : 0;
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(this.fid, dst, dstIndex);
        SMBUtil.writeInt4(this.offset, dst, dstIndex += 2);
        SMBUtil.writeInt2(this.maxCount, dst, dstIndex += 4);
        SMBUtil.writeInt2(this.minCount, dst, dstIndex += 2);
        SMBUtil.writeInt4(this.openTimeout, dst, dstIndex += 2);
        SMBUtil.writeInt2(this.remaining, dst, dstIndex += 4);
        SMBUtil.writeInt4(this.offset >> 32, dst, dstIndex += 2);
        return (dstIndex += 4) - start;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return "SmbComReadAndX[" + super.toString() + ",fid=" + this.fid + ",offset=" + this.offset + ",maxCount=" + this.maxCount + ",minCount=" + this.minCount + ",openTimeout=" + this.openTimeout + ",remaining=" + this.remaining + ",offset=" + this.offset + "]";
    }
}

