/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.com;

import java.util.Date;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.smb1.AndXServerMessageBlock;
import org.codelibs.jcifs.smb.internal.smb1.ServerMessageBlock;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;
import org.codelibs.jcifs.smb.util.Hexdump;

public class SmbComOpenAndX
extends AndXServerMessageBlock {
    static final int FLAGS_RETURN_ADDITIONAL_INFO = 1;
    static final int FLAGS_REQUEST_OPLOCK = 2;
    static final int FLAGS_REQUEST_BATCH_OPLOCK = 4;
    static final int SHARING_COMPATIBILITY = 0;
    static final int SHARING_DENY_READ_WRITE_EXECUTE = 16;
    static final int SHARING_DENY_WRITE = 32;
    static final int SHARING_DENY_READ_EXECUTE = 48;
    static final int SHARING_DENY_NONE = 64;
    static final int DO_NOT_CACHE = 4096;
    static final int WRITE_THROUGH = 16384;
    static final int OPEN_FN_CREATE = 16;
    static final int OPEN_FN_FAIL_IF_EXISTS = 0;
    static final int OPEN_FN_OPEN = 1;
    static final int OPEN_FN_TRUNC = 2;
    int tflags;
    int desiredAccess;
    int searchAttributes;
    int fileAttributes;
    int creationTime;
    int openFunction;
    int allocationSize;

    public SmbComOpenAndX(Configuration config, String fileName, int access, int shareAccess, int flags, int fileAttributes, ServerMessageBlock andx) {
        super(config, (byte)45, fileName, andx);
        this.fileAttributes = fileAttributes;
        this.desiredAccess = access & 3;
        if (this.desiredAccess == 3) {
            this.desiredAccess = 2;
        }
        this.desiredAccess = (shareAccess & 1) != 0 && (shareAccess & 2) != 0 ? (this.desiredAccess |= 0x40) : (shareAccess == 0 ? (this.desiredAccess |= 0x10) : ((shareAccess & 2) == 0 ? (this.desiredAccess |= 0x20) : ((shareAccess & 1) == 0 ? (this.desiredAccess |= 0x30) : (this.desiredAccess |= 0x10))));
        this.desiredAccess &= 0xFFFFFFFE;
        this.searchAttributes = 22;
        this.openFunction = (flags & 0x40) == 64 ? ((flags & 0x10) == 16 ? 18 : 2) : ((flags & 0x10) == 16 ? ((flags & 0x20) == 32 ? 16 : 17) : 1);
    }

    @Override
    protected int getBatchLimit(Configuration cfg, byte cmd) {
        return cmd == 46 ? cfg.getBatchLimit("OpenAndX.ReadAndX") : 0;
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(this.tflags, dst, dstIndex);
        SMBUtil.writeInt2(this.desiredAccess, dst, dstIndex += 2);
        SMBUtil.writeInt2(this.searchAttributes, dst, dstIndex += 2);
        SMBUtil.writeInt2(this.fileAttributes, dst, dstIndex += 2);
        this.creationTime = 0;
        SMBUtil.writeInt4(this.creationTime, dst, dstIndex += 2);
        SMBUtil.writeInt2(this.openFunction, dst, dstIndex += 4);
        SMBUtil.writeInt4(this.allocationSize, dst, dstIndex += 2);
        dstIndex += 4;
        for (int i = 0; i < 8; ++i) {
            dst[dstIndex] = 0;
            ++dstIndex;
        }
        return dstIndex - start;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        if (this.isUseUnicode()) {
            dst[dstIndex] = 0;
            ++dstIndex;
        }
        dstIndex += this.writeString(this.path, dst, dstIndex);
        return dstIndex - start;
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return "SmbComOpenAndX[" + super.toString() + ",flags=0x" + Hexdump.toHexString(this.tflags, 2) + ",desiredAccess=0x" + Hexdump.toHexString(this.desiredAccess, 4) + ",searchAttributes=0x" + Hexdump.toHexString(this.searchAttributes, 4) + ",fileAttributes=0x" + Hexdump.toHexString(this.fileAttributes, 4) + ",creationTime=" + String.valueOf(new Date(this.creationTime)) + ",openFunction=0x" + Hexdump.toHexString(this.openFunction, 2) + ",allocationSize=" + this.allocationSize + ",fileName=" + this.path + "]";
    }
}

