/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.com;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.RuntimeCIFSException;
import org.codelibs.jcifs.smb.internal.SmbNegotiationRequest;
import org.codelibs.jcifs.smb.internal.smb1.ServerMessageBlock;
import org.codelibs.jcifs.smb.util.Strings;

public class SmbComNegotiate
extends ServerMessageBlock
implements SmbNegotiationRequest {
    private final boolean signingEnforced;
    private String[] dialects;

    public SmbComNegotiate(Configuration config, boolean signingEnforced) {
        super(config, (byte)114);
        this.signingEnforced = signingEnforced;
        this.setFlags2(config.getFlags2());
        this.dialects = config.getMinimumVersion().isSMB2() ? new String[]{"SMB 2.???", "SMB 2.002"} : (config.getMaximumVersion().isSMB2() ? new String[]{"NT LM 0.12", "SMB 2.???", "SMB 2.002"} : new String[]{"NT LM 0.12"});
    }

    @Override
    public boolean isSigningEnforced() {
        return this.signingEnforced;
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (String dialect : this.dialects) {
            bos.write(2);
            try {
                bos.write(Strings.getASCIIBytes(dialect));
            }
            catch (IOException e) {
                throw new RuntimeCIFSException(e);
            }
            bos.write(0);
        }
        System.arraycopy(bos.toByteArray(), 0, dst, dstIndex, bos.size());
        return bos.size();
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return "SmbComNegotiate[" + super.toString() + ",wordCount=" + this.wordCount + ",dialects=NT LM 0.12]";
    }
}

