/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.fscc;

import java.util.Date;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.Decodable;
import org.codelibs.jcifs.smb.impl.FileEntry;
import org.codelibs.jcifs.smb.internal.SMBProtocolDecodingException;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;
import org.codelibs.jcifs.smb.util.Strings;

public class FileBothDirectoryInfo
implements FileEntry,
Decodable {
    private int nextEntryOffset;
    private int fileIndex;
    private long creationTime;
    private long lastAccessTime;
    private long lastWriteTime;
    private long changeTime;
    private long endOfFile;
    private long allocationSize;
    private int extFileAttributes;
    private int eaSize;
    private String shortName;
    private String filename;
    private final Configuration config;
    private final boolean unicode;

    public FileBothDirectoryInfo(Configuration config, boolean unicode) {
        this.config = config;
        this.unicode = unicode;
    }

    @Override
    public String getName() {
        return this.filename;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public int getFileIndex() {
        return this.fileIndex;
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public int getAttributes() {
        return this.extFileAttributes;
    }

    @Override
    public long createTime() {
        return this.creationTime;
    }

    @Override
    public long lastModified() {
        return this.lastWriteTime;
    }

    @Override
    public long lastAccess() {
        return this.lastAccessTime;
    }

    @Override
    public long length() {
        return this.endOfFile;
    }

    public int getNextEntryOffset() {
        return this.nextEntryOffset;
    }

    @Override
    public int decode(byte[] buffer, int bufferIndex, int len) throws SMBProtocolDecodingException {
        String str;
        int start = bufferIndex;
        this.nextEntryOffset = SMBUtil.readInt4(buffer, bufferIndex);
        this.fileIndex = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.creationTime = SMBUtil.readTime(buffer, bufferIndex += 4);
        this.lastAccessTime = SMBUtil.readTime(buffer, bufferIndex += 8);
        this.lastWriteTime = SMBUtil.readTime(buffer, bufferIndex += 8);
        this.changeTime = SMBUtil.readTime(buffer, bufferIndex += 8);
        this.endOfFile = SMBUtil.readInt8(buffer, bufferIndex += 8);
        this.allocationSize = SMBUtil.readInt8(buffer, bufferIndex += 8);
        this.extFileAttributes = SMBUtil.readInt4(buffer, bufferIndex += 8);
        int fileNameLength = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.eaSize = SMBUtil.readInt4(buffer, bufferIndex += 4);
        int shortNameLength = buffer[bufferIndex += 4] & 0xFF;
        this.shortName = Strings.fromUNIBytes(buffer, bufferIndex += 2, shortNameLength);
        bufferIndex += 24;
        if (this.unicode) {
            if (fileNameLength > 0 && buffer[bufferIndex + fileNameLength - 1] == 0 && buffer[bufferIndex + fileNameLength - 2] == 0) {
                fileNameLength -= 2;
            }
            str = Strings.fromUNIBytes(buffer, bufferIndex, fileNameLength);
        } else {
            if (fileNameLength > 0 && buffer[bufferIndex + fileNameLength - 1] == 0) {
                --fileNameLength;
            }
            str = Strings.fromOEMBytes(buffer, bufferIndex, fileNameLength, this.config);
        }
        this.filename = str;
        return start - (bufferIndex += fileNameLength);
    }

    public String toString() {
        return "SmbFindFileBothDirectoryInfo[nextEntryOffset=" + this.nextEntryOffset + ",fileIndex=" + this.fileIndex + ",creationTime=" + String.valueOf(new Date(this.creationTime)) + ",lastAccessTime=" + String.valueOf(new Date(this.lastAccessTime)) + ",lastWriteTime=" + String.valueOf(new Date(this.lastWriteTime)) + ",changeTime=" + String.valueOf(new Date(this.changeTime)) + ",endOfFile=" + this.endOfFile + ",allocationSize=" + this.allocationSize + ",extFileAttributes=" + this.extFileAttributes + ",eaSize=" + this.eaSize + ",shortName=" + this.shortName + ",filename=" + this.filename + "]";
    }
}

