/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.dtyp;

import org.codelibs.jcifs.smb.Decodable;
import org.codelibs.jcifs.smb.impl.SID;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;
import org.codelibs.jcifs.smb.util.Hexdump;

public class ACE
implements org.codelibs.jcifs.smb.ACE,
Decodable {
    boolean allow;
    int flags;
    int access;
    SID sid;

    @Override
    public boolean isAllow() {
        return this.allow;
    }

    @Override
    public boolean isInherited() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public String getApplyToText() {
        switch (this.flags & 0xB) {
            case 0: {
                return "This folder only";
            }
            case 3: {
                return "This folder, subfolders and files";
            }
            case 11: {
                return "Subfolders and files only";
            }
            case 2: {
                return "This folder and subfolders";
            }
            case 10: {
                return "Subfolders only";
            }
            case 1: {
                return "This folder and files";
            }
            case 9: {
                return "Files only";
            }
        }
        return "Invalid";
    }

    @Override
    public int getAccessMask() {
        return this.access;
    }

    @Override
    public SID getSID() {
        return this.sid;
    }

    @Override
    public int decode(byte[] buf, int bi, int len) {
        this.allow = buf[bi] == 0;
        int n = ++bi;
        this.flags = buf[n] & 0xFF;
        int size = SMBUtil.readInt2(buf, ++bi);
        this.access = SMBUtil.readInt4(buf, bi += 2);
        this.sid = new SID(buf, bi += 4);
        return size;
    }

    void appendCol(StringBuffer sb, String str, int width) {
        sb.append(str);
        int count = width - str.length();
        for (int i = 0; i < count; ++i) {
            sb.append(' ');
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.isAllow() ? "Allow " : "Deny  ");
        this.appendCol(sb, this.sid.toDisplayString(), 25);
        sb.append(" 0x").append(Hexdump.toHexString(this.access, 8)).append(' ');
        sb.append(this.isInherited() ? "Inherited " : "Direct    ");
        this.appendCol(sb, this.getApplyToText(), 34);
        return sb.toString();
    }
}

