/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.impl;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.codelibs.jcifs.smb.CIFSException;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.RuntimeCIFSException;
import org.codelibs.jcifs.smb.SmbTreeHandle;
import org.codelibs.jcifs.smb.impl.RequestParam;
import org.codelibs.jcifs.smb.impl.SmbException;
import org.codelibs.jcifs.smb.impl.SmbResourceLocatorImpl;
import org.codelibs.jcifs.smb.impl.SmbSessionImpl;
import org.codelibs.jcifs.smb.impl.SmbTransportImpl;
import org.codelibs.jcifs.smb.impl.SmbTreeConnection;
import org.codelibs.jcifs.smb.impl.SmbTreeHandleInternal;
import org.codelibs.jcifs.smb.internal.CommonServerMessageBlockRequest;
import org.codelibs.jcifs.smb.internal.CommonServerMessageBlockResponse;
import org.codelibs.jcifs.smb.internal.Request;
import org.codelibs.jcifs.smb.internal.SmbNegotiationResponse;
import org.codelibs.jcifs.smb.internal.smb1.com.SmbComNegotiateResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmbTreeHandleImpl
implements SmbTreeHandleInternal {
    private static final Logger log = LoggerFactory.getLogger(SmbTreeHandleImpl.class);
    private final SmbResourceLocatorImpl resourceLoc;
    private final SmbTreeConnection treeConnection;
    private final AtomicLong usageCount = new AtomicLong(1L);

    public SmbTreeHandleImpl(SmbResourceLocatorImpl resourceLoc, SmbTreeConnection treeConnection) {
        this.resourceLoc = resourceLoc;
        this.treeConnection = treeConnection.acquire();
    }

    @Override
    public SmbSessionImpl getSession() {
        return this.treeConnection.getSession();
    }

    @Override
    public void ensureDFSResolved() throws CIFSException {
        this.treeConnection.ensureDFSResolved(this.resourceLoc);
    }

    @Override
    public boolean hasCapability(int cap) throws SmbException {
        return this.treeConnection.hasCapability(cap);
    }

    @Override
    public boolean isConnected() {
        return this.treeConnection.isConnected();
    }

    @Override
    public Configuration getConfig() {
        return this.treeConnection.getConfig();
    }

    public long getTreeId() {
        return this.treeConnection.getTreeId();
    }

    public <T extends CommonServerMessageBlockResponse> T send(Request<T> req, RequestParam ... params) throws CIFSException {
        return this.send((CommonServerMessageBlockRequest)req, null, params);
    }

    public <T extends CommonServerMessageBlockResponse> T send(CommonServerMessageBlockRequest request, T response, RequestParam ... params) throws CIFSException {
        return this.treeConnection.send(this.resourceLoc, request, response, params);
    }

    public <T extends CommonServerMessageBlockResponse> T send(CommonServerMessageBlockRequest request, T response, Set<RequestParam> params) throws CIFSException {
        return this.treeConnection.send(this.resourceLoc, request, response, params);
    }

    @Override
    public synchronized void close() {
        this.release();
    }

    public SmbTreeHandleImpl acquire() {
        if (this.usageCount.incrementAndGet() == 1L) {
            this.treeConnection.acquire();
        }
        return this;
    }

    @Override
    public void release() {
        long us = this.usageCount.decrementAndGet();
        if (us == 0L) {
            this.treeConnection.release();
        } else if (us < 0L) {
            throw new RuntimeCIFSException("Usage count dropped below zero");
        }
    }

    protected void finalize() throws Throwable {
        if (this.usageCount.get() != 0L) {
            log.warn("Tree handle was not properly released " + String.valueOf(this.resourceLoc.getURL()));
        }
    }

    @Override
    public String getRemoteHostName() {
        try (SmbSessionImpl session = this.treeConnection.getSession();){
            String string;
            block12: {
                SmbTransportImpl transport = session.getTransport();
                try {
                    string = transport.getRemoteHostName();
                    if (transport == null) break block12;
                }
                catch (Throwable throwable) {
                    if (transport != null) {
                        try {
                            transport.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                transport.close();
            }
            return string;
        }
    }

    @Override
    public long getServerTimeZoneOffset() throws SmbException {
        try (SmbSessionImpl session = this.treeConnection.getSession();){
            long l;
            block16: {
                SmbTransportImpl transport;
                block14: {
                    long l2;
                    block15: {
                        transport = session.getTransport();
                        try {
                            SmbNegotiationResponse nego = transport.getNegotiateResponse();
                            if (!(nego instanceof SmbComNegotiateResponse)) break block14;
                            l2 = (long)(((SmbComNegotiateResponse)nego).getServerData().serverTimeZone * 1000) * 60L;
                            if (transport == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (transport != null) {
                                try {
                                    transport.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        transport.close();
                    }
                    return l2;
                }
                l = 0L;
                if (transport == null) break block16;
                transport.close();
            }
            return l;
        }
    }

    @Override
    public String getOEMDomainName() throws SmbException {
        try (SmbSessionImpl session = this.treeConnection.getSession();){
            String string;
            block16: {
                SmbTransportImpl transport;
                block14: {
                    String string2;
                    block15: {
                        transport = session.getTransport();
                        try {
                            SmbNegotiationResponse nego = transport.getNegotiateResponse();
                            if (!(nego instanceof SmbComNegotiateResponse)) break block14;
                            string2 = ((SmbComNegotiateResponse)nego).getServerData().oemDomainName;
                            if (transport == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (transport != null) {
                                try {
                                    transport.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        transport.close();
                    }
                    return string2;
                }
                string = null;
                if (transport == null) break block16;
                transport.close();
            }
            return string;
        }
    }

    @Override
    public int getTreeType() {
        return this.treeConnection.getTreeType();
    }

    @Override
    public String getConnectedShare() {
        return this.treeConnection.getConnectedShare();
    }

    @Override
    public boolean isSameTree(SmbTreeHandle th) {
        if (!(th instanceof SmbTreeHandleImpl)) {
            return false;
        }
        return this.treeConnection.isSame(((SmbTreeHandleImpl)th).treeConnection);
    }

    @Override
    public int getSendBufferSize() throws SmbException {
        try (SmbSessionImpl session = this.treeConnection.getSession();){
            int n;
            block12: {
                SmbTransportImpl transport = session.getTransport();
                try {
                    n = transport.getNegotiateResponse().getSendBufferSize();
                    if (transport == null) break block12;
                }
                catch (Throwable throwable) {
                    if (transport != null) {
                        try {
                            transport.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                transport.close();
            }
            return n;
        }
    }

    @Override
    public int getReceiveBufferSize() throws SmbException {
        try (SmbSessionImpl session = this.treeConnection.getSession();){
            int n;
            block12: {
                SmbTransportImpl transport = session.getTransport();
                try {
                    n = transport.getNegotiateResponse().getReceiveBufferSize();
                    if (transport == null) break block12;
                }
                catch (Throwable throwable) {
                    if (transport != null) {
                        try {
                            transport.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                transport.close();
            }
            return n;
        }
    }

    @Override
    public int getMaximumBufferSize() throws SmbException {
        try (SmbSessionImpl session = this.treeConnection.getSession();){
            int n;
            block12: {
                SmbTransportImpl transport = session.getTransport();
                try {
                    n = transport.getNegotiateResponse().getTransactionBufferSize();
                    if (transport == null) break block12;
                }
                catch (Throwable throwable) {
                    if (transport != null) {
                        try {
                            transport.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                transport.close();
            }
            return n;
        }
    }

    @Override
    public boolean areSignaturesActive() throws SmbException {
        try (SmbSessionImpl session = this.treeConnection.getSession();){
            boolean bl;
            block12: {
                SmbTransportImpl transport = session.getTransport();
                try {
                    bl = transport.getNegotiateResponse().isSigningNegotiated();
                    if (transport == null) break block12;
                }
                catch (Throwable throwable) {
                    if (transport != null) {
                        try {
                            transport.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                transport.close();
            }
            return bl;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isSMB2() {
        try (SmbSessionImpl session = this.treeConnection.getSession();){
            boolean bl;
            block14: {
                SmbTransportImpl transport = session.getTransport();
                try {
                    bl = transport.isSMB2();
                    if (transport == null) break block14;
                }
                catch (Throwable throwable) {
                    if (transport != null) {
                        try {
                            transport.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                transport.close();
            }
            return bl;
        }
        catch (SmbException e) {
            log.debug("Failed to connect for determining SMB2 support", (Throwable)e);
            return false;
        }
    }
}

