/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import org.codelibs.jcifs.smb.CIFSException;
import org.codelibs.jcifs.smb.CloseableIterator;
import org.codelibs.jcifs.smb.SmbResource;
import org.codelibs.jcifs.smb.impl.RequestParam;
import org.codelibs.jcifs.smb.impl.SmbAuthException;
import org.codelibs.jcifs.smb.impl.SmbEnumerationUtil;
import org.codelibs.jcifs.smb.impl.SmbException;
import org.codelibs.jcifs.smb.impl.SmbFile;
import org.codelibs.jcifs.smb.impl.SmbFileHandleImpl;
import org.codelibs.jcifs.smb.impl.SmbFileInputStream;
import org.codelibs.jcifs.smb.impl.SmbFileOutputStream;
import org.codelibs.jcifs.smb.impl.SmbTreeHandleImpl;
import org.codelibs.jcifs.smb.impl.SmbUnsupportedOperationException;
import org.codelibs.jcifs.smb.impl.WriterThread;
import org.codelibs.jcifs.smb.internal.CommonServerMessageBlockRequest;
import org.codelibs.jcifs.smb.internal.fscc.FileBasicInfo;
import org.codelibs.jcifs.smb.internal.smb1.com.SmbComSetInformation;
import org.codelibs.jcifs.smb.internal.smb1.com.SmbComSetInformationResponse;
import org.codelibs.jcifs.smb.internal.smb1.trans2.Trans2SetFileInformation;
import org.codelibs.jcifs.smb.internal.smb1.trans2.Trans2SetFileInformationResponse;
import org.codelibs.jcifs.smb.internal.smb2.info.Smb2SetInfoRequest;
import org.codelibs.jcifs.smb.internal.smb2.ioctl.Smb2IoctlRequest;
import org.codelibs.jcifs.smb.internal.smb2.ioctl.Smb2IoctlResponse;
import org.codelibs.jcifs.smb.internal.smb2.ioctl.SrvCopyChunkCopyResponse;
import org.codelibs.jcifs.smb.internal.smb2.ioctl.SrvCopychunk;
import org.codelibs.jcifs.smb.internal.smb2.ioctl.SrvCopychunkCopy;
import org.codelibs.jcifs.smb.internal.smb2.ioctl.SrvRequestResumeKeyResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmbCopyUtil {
    private static final Logger log = LoggerFactory.getLogger(SmbCopyUtil.class);

    private SmbCopyUtil() {
    }

    static SmbFileHandleImpl openCopyTargetFile(SmbFile dest, int attrs, boolean alsoRead) throws CIFSException {
        try {
            return dest.openUnshared(82, 0x102 | (alsoRead ? 1 : 0), 0, attrs, 0);
        }
        catch (SmbAuthException sae) {
            log.trace("copyTo0", (Throwable)sae);
            int dattrs = dest.getAttributes();
            if ((dattrs & 1) != 0) {
                dest.setPathInformation(dattrs & 0xFFFFFFFE, 0L, 0L, 0L);
                return dest.openUnshared(82, 0x102 | (alsoRead ? 1 : 0), 0, attrs, 0);
            }
            throw sae;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyFile(SmbFile src, SmbFile dest, byte[][] b, int bsize, WriterThread w, SmbTreeHandleImpl sh, SmbTreeHandleImpl dh) throws SmbException {
        if (sh.isSMB2() && dh.isSMB2() && sh.isSameTree(dh)) {
            try {
                SmbCopyUtil.serverSideCopy(src, dest, sh, dh, false);
                return;
            }
            catch (SmbUnsupportedOperationException e) {
                log.debug("Server side copy not supported, falling back to normal copying", (Throwable)e);
            }
            catch (CIFSException e) {
                log.warn("Server side copy failed", (Throwable)e);
                throw SmbException.wrap(e);
            }
        }
        try (SmbFileHandleImpl sfd = src.openUnshared(0, 1, 1, 128, 0);
             SmbFileInputStream fis = new SmbFileInputStream(src, sh, sfd);){
            int attrs = src.getAttributes();
            try (SmbFileHandleImpl dfd = SmbCopyUtil.openCopyTargetFile(dest, attrs, false);
                 SmbFileOutputStream fos = new SmbFileOutputStream(dest, dh, dfd, 82, 258, 0);){
                long mtime = src.lastModified();
                long ctime = src.createTime();
                long atime = src.lastAccess();
                int i = 0;
                long off = 0L;
                while (true) {
                    int read = fis.read(b[i]);
                    WriterThread writerThread = w;
                    synchronized (writerThread) {
                        w.checkException();
                        while (!w.isReady()) {
                            try {
                                w.wait();
                            }
                            catch (InterruptedException ie) {
                                throw new SmbException(dest.getURL().toString(), (Throwable)ie);
                            }
                        }
                        w.checkException();
                        if (read <= 0) {
                            break;
                        }
                        w.write(b[i], read, fos);
                    }
                    i = i == 1 ? 0 : 1;
                    off += (long)read;
                }
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Copied a total of %d bytes", off));
                }
                if (dh.isSMB2()) {
                    Smb2SetInfoRequest req = new Smb2SetInfoRequest(dh.getConfig(), dfd.getFileId());
                    req.setFileInformation(new FileBasicInfo(ctime, atime, mtime, 0L, attrs));
                    dh.send(req, new RequestParam[0]);
                } else if (dh.hasCapability(16)) {
                    dh.send((CommonServerMessageBlockRequest)new Trans2SetFileInformation(dh.getConfig(), dfd.getFid(), attrs, ctime, mtime, atime), new Trans2SetFileInformationResponse(dh.getConfig()), new RequestParam[0]);
                } else {
                    dh.send((CommonServerMessageBlockRequest)new SmbComSetInformation(dh.getConfig(), dest.getUncPath(), attrs, mtime), new SmbComSetInformationResponse(dh.getConfig()), new RequestParam[0]);
                }
            }
        }
        catch (IOException se) {
            if (!src.getContext().getConfig().isIgnoreCopyToException()) {
                throw new SmbException("Failed to copy file from [" + src.toString() + "] to [" + dest.toString() + "]", (Throwable)se);
            }
            log.warn("Copy failed", (Throwable)se);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void serverSideCopy(SmbFile src, SmbFile dest, SmbTreeHandleImpl sh, SmbTreeHandleImpl dh, boolean write) throws CIFSException {
        long ooff;
        boolean retry;
        int byteLimit;
        int maxChunkSize;
        int maxChunks;
        byte[] resumeKey;
        long size;
        SmbFileHandleImpl dfd;
        long atime;
        long ctime;
        long mtime;
        int attrs;
        block39: {
            log.debug("Trying server side copy");
            attrs = src.getAttributes();
            mtime = src.lastModified();
            ctime = src.createTime();
            atime = src.lastAccess();
            dfd = null;
            try (SmbFileHandleImpl sfd = src.openUnshared(0, 1, 1, 128, 0);){
                SmbFileHandleImpl edfd;
                if (sfd.getInitialSize() == 0L) {
                    edfd = SmbCopyUtil.openCopyTargetFile(dest, attrs, !write);
                    if (dh.isSMB2()) {
                        Smb2SetInfoRequest req = new Smb2SetInfoRequest(dh.getConfig(), edfd.getFileId());
                        req.setFileInformation(new FileBasicInfo(ctime, atime, mtime, 0L, attrs));
                        dh.send(req, new RequestParam[0]);
                        return;
                    }
                    if (dh.hasCapability(16)) {
                        dh.send((CommonServerMessageBlockRequest)new Trans2SetFileInformation(dh.getConfig(), edfd.getFid(), attrs, ctime, mtime, atime), new Trans2SetFileInformationResponse(dh.getConfig()), new RequestParam[0]);
                        return;
                    }
                    dh.send((CommonServerMessageBlockRequest)new SmbComSetInformation(dh.getConfig(), dest.getUncPath(), attrs, mtime), new SmbComSetInformationResponse(dh.getConfig()), new RequestParam[0]);
                    return;
                }
                Smb2IoctlRequest resumeReq = new Smb2IoctlRequest(sh.getConfig(), 1310840, sfd.getFileId());
                resumeReq.setFlags(1);
                Smb2IoctlResponse resumeResp = sh.send(resumeReq, new RequestParam[0]);
                SrvRequestResumeKeyResponse rkresp = resumeResp.getOutputData(SrvRequestResumeKeyResponse.class);
                size = sfd.getInitialSize();
                resumeKey = rkresp.getResumeKey();
                maxChunks = 256;
                maxChunkSize = 0x100000;
                byteLimit = 0x1000000;
                retry = false;
                ooff = 0L;
                break block39;
                finally {
                    if (edfd != null) {
                        edfd.close();
                    }
                }
            }
            catch (SmbUnsupportedOperationException e) {
                throw e;
            }
            catch (IOException se) {
                throw new CIFSException("Server side copy failed", se);
            }
            finally {
                if (dfd != null) {
                    dfd.close();
                }
            }
        }
        while (true) {
            long ioff;
            SrvCopychunk[] chunkInfo;
            int lastChunkSize;
            int chunks;
            if (ooff < size) {
                long wsize = size - ooff;
                if (wsize > (long)byteLimit) {
                    wsize = byteLimit;
                }
                if ((chunks = (int)(wsize / (long)maxChunkSize)) + 1 > maxChunks) {
                    chunks = maxChunks;
                    lastChunkSize = maxChunkSize;
                } else {
                    lastChunkSize = (int)(wsize % (long)maxChunkSize);
                    if (lastChunkSize != 0) {
                        ++chunks;
                    } else {
                        lastChunkSize = maxChunkSize;
                    }
                }
                chunkInfo = new SrvCopychunk[chunks];
                ioff = 0L;
            } else {
                if (dfd == null) return;
                if (!dfd.isValid()) return;
                if (dh.isSMB2()) {
                    Smb2SetInfoRequest req = new Smb2SetInfoRequest(dh.getConfig(), dfd.getFileId());
                    req.setFileInformation(new FileBasicInfo(ctime, atime, mtime, 0L, attrs));
                    dh.send(req, new RequestParam[0]);
                    return;
                }
                if (dh.hasCapability(16)) {
                    dh.send((CommonServerMessageBlockRequest)new Trans2SetFileInformation(dh.getConfig(), dfd.getFid(), attrs, ctime, mtime, atime), new Trans2SetFileInformationResponse(dh.getConfig()), new RequestParam[0]);
                    return;
                }
                dh.send((CommonServerMessageBlockRequest)new SmbComSetInformation(dh.getConfig(), dest.getUncPath(), attrs, mtime), new SmbComSetInformationResponse(dh.getConfig()), new RequestParam[0]);
                return;
            }
            for (int i = 0; i < chunks; ioff += (long)maxChunkSize, ++i) {
                long absoff = ooff + ioff;
                int csize = i == chunks - 1 ? lastChunkSize : maxChunkSize;
                chunkInfo[i] = new SrvCopychunk(absoff, absoff, csize);
            }
            if (dfd == null || !dfd.isValid()) {
                dfd = SmbCopyUtil.openCopyTargetFile(dest, attrs, !write);
            }
            Smb2IoctlRequest copy = new Smb2IoctlRequest(sh.getConfig(), write ? 1343730 : 1327346, dfd.getFileId());
            copy.setFlags(1);
            copy.setInputData(new SrvCopychunkCopy(resumeKey, chunkInfo));
            try {
                SrvCopyChunkCopyResponse r = dh.send(copy, RequestParam.NO_RETRY).getOutputData(SrvCopyChunkCopyResponse.class);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Wrote %d bytes (%d chunks, last partial write %d)", r.getTotalBytesWritten(), r.getChunksWritten(), r.getChunkBytesWritten()));
                }
                ooff += (long)r.getTotalBytesWritten();
                continue;
            }
            catch (SmbException e) {
                Smb2IoctlResponse response = (Smb2IoctlResponse)copy.getResponse();
                if (retry) throw e;
                if (!response.isReceived()) throw e;
                if (response.isError()) throw e;
                if (response.getStatus() != -1073741811) throw e;
                retry = true;
                SrvCopyChunkCopyResponse outputData = response.getOutputData(SrvCopyChunkCopyResponse.class);
                maxChunks = outputData.getChunksWritten();
                maxChunkSize = outputData.getChunkBytesWritten();
                byteLimit = outputData.getTotalBytesWritten();
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void copyDir(SmbFile src, SmbFile dest, byte[][] b, int bsize, WriterThread w, SmbTreeHandleImpl sh, SmbTreeHandleImpl dh) throws CIFSException {
        block26: {
            String path = dest.getLocator().getUNCPath();
            if (path.length() > 1) {
                try {
                    dest.mkdir();
                    if (dh.hasCapability(16)) {
                        dest.setPathInformation(src.getAttributes(), src.createTime(), src.lastModified(), src.lastAccess());
                    } else {
                        dest.setPathInformation(src.getAttributes(), 0L, src.lastModified(), 0L);
                    }
                }
                catch (SmbUnsupportedOperationException e) {
                    if (!src.getContext().getConfig().isIgnoreCopyToException()) {
                        throw e;
                    }
                    log.warn("Failed to set file attributes on " + path, (Throwable)e);
                }
                catch (SmbException se) {
                    log.trace("copyTo0", (Throwable)se);
                    if (se.getNtStatus() == -1073741790 || se.getNtStatus() == -1073741771) break block26;
                    throw se;
                }
            }
        }
        try (CloseableIterator<SmbResource> it = SmbEnumerationUtil.doEnum(src, "*", 22, null, null);){
            while (it.hasNext()) {
                SmbResource r = (SmbResource)it.next();
                try (SmbFile ndest = new SmbFile(dest, r.getLocator().getName(), true, r.getLocator().getType(), r.getAttributes(), r.createTime(), r.lastModified(), r.lastAccess(), r.length());){
                    if (!(r instanceof SmbFile)) continue;
                    ((SmbFile)r).copyRecursive(ndest, b, bsize, w, sh, dh);
                }
                finally {
                    if (r == null) continue;
                    r.close();
                }
            }
            return;
        }
        catch (MalformedURLException mue) {
            throw new SmbException(src.getURL().toString(), (Throwable)mue);
        }
    }
}

