/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.impl;

import org.codelibs.jcifs.smb.CIFSException;
import org.codelibs.jcifs.smb.CloseableIterator;
import org.codelibs.jcifs.smb.ResourceNameFilter;
import org.codelibs.jcifs.smb.SmbResource;
import org.codelibs.jcifs.smb.SmbResourceLocator;
import org.codelibs.jcifs.smb.impl.FileEntry;
import org.codelibs.jcifs.smb.impl.RequestParam;
import org.codelibs.jcifs.smb.impl.SmbException;
import org.codelibs.jcifs.smb.impl.SmbFile;
import org.codelibs.jcifs.smb.impl.SmbTreeHandleImpl;
import org.codelibs.jcifs.smb.impl.SmbUnsupportedOperationException;
import org.codelibs.jcifs.smb.internal.CommonServerMessageBlockRequest;
import org.codelibs.jcifs.smb.internal.smb1.net.NetServerEnum2;
import org.codelibs.jcifs.smb.internal.smb1.net.NetServerEnum2Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetServerEnumIterator
implements CloseableIterator<FileEntry> {
    private static final Logger log = LoggerFactory.getLogger(NetServerEnumIterator.class);
    private final NetServerEnum2 request;
    private final NetServerEnum2Response response;
    private final SmbResource parent;
    private final SmbTreeHandleImpl treeHandle;
    private final ResourceNameFilter nameFilter;
    private final boolean workgroup;
    private int ridx;
    private FileEntry next;

    public NetServerEnumIterator(SmbFile parent, SmbTreeHandleImpl th, String wildcard, int searchAttributes, ResourceNameFilter filter) throws CIFSException {
        this.parent = parent;
        this.nameFilter = filter;
        SmbResourceLocator locator = parent.getLocator();
        boolean bl = this.workgroup = locator.getType() == 2;
        if (locator.getURL().getHost().isEmpty()) {
            this.request = new NetServerEnum2(th.getConfig(), th.getOEMDomainName(), Integer.MIN_VALUE);
        } else if (this.workgroup) {
            this.request = new NetServerEnum2(th.getConfig(), locator.getURL().getHost(), -1);
        } else {
            throw new SmbException("The requested list operations is invalid: " + String.valueOf(locator.getURL()));
        }
        this.response = new NetServerEnum2Response(th.getConfig());
        this.treeHandle = th.acquire();
        try {
            this.next = this.open();
        }
        catch (Exception e) {
            this.treeHandle.release();
            throw e;
        }
    }

    private FileEntry open() throws CIFSException {
        this.treeHandle.send((CommonServerMessageBlockRequest)this.request, this.response, new RequestParam[0]);
        this.checkStatus();
        FileEntry n = this.advance();
        if (n == null) {
            this.doClose();
        }
        return n;
    }

    private void checkStatus() throws SmbException {
        int status = this.response.getStatus();
        if (status == 2184) {
            throw new SmbUnsupportedOperationException();
        }
        if (status != 0 && status != 234) {
            throw new SmbException(status, true);
        }
    }

    private FileEntry advance() throws CIFSException {
        int n;
        int n2 = n = this.response.getStatus() == 234 ? this.response.getNumEntries() - 1 : this.response.getNumEntries();
        while (this.ridx < n) {
            FileEntry itm = this.response.getResults()[this.ridx];
            ++this.ridx;
            if (!this.filter(itm)) continue;
            return itm;
        }
        if (this.workgroup && this.response.getStatus() == 234) {
            this.request.reset(0, this.response.getLastName());
            this.response.reset();
            this.request.setSubCommand((byte)-41);
            this.treeHandle.send((CommonServerMessageBlockRequest)this.request, this.response, new RequestParam[0]);
            this.checkStatus();
            this.ridx = 0;
            return this.advance();
        }
        return null;
    }

    private final boolean filter(FileEntry fe) {
        String name = fe.getName();
        if (this.nameFilter == null) {
            return true;
        }
        try {
            return this.nameFilter.accept(this.parent, name);
        }
        catch (CIFSException e) {
            log.error("Failed to apply name filter", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public FileEntry next() {
        FileEntry n = this.next;
        try {
            FileEntry ne = this.advance();
            if (ne == null) {
                this.doClose();
                return n;
            }
            this.next = ne;
        }
        catch (CIFSException e) {
            log.warn("Enumeration failed", (Throwable)e);
            this.next = null;
        }
        return n;
    }

    @Override
    public void close() throws CIFSException {
        if (this.next != null) {
            this.doClose();
        }
    }

    private void doClose() {
        this.treeHandle.release();
        this.next = null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

