/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.dcerpc;

import org.codelibs.jcifs.smb.dcerpc.rpc;

public class UUID
extends rpc.uuid_t {
    static final char[] HEXCHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static int hex_to_bin(char[] arr, int offset, int length) {
        int value = 0;
        int count = 0;
        block5: for (int ai = offset; ai < arr.length && count < length; ++count, ++ai) {
            value <<= 4;
            switch (arr[ai]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value += arr[ai] - 48;
                    continue block5;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    value += 10 + arr[ai] - 65;
                    continue block5;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    value += 10 + arr[ai] - 97;
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException(new String(arr, offset, length));
                }
            }
        }
        return value;
    }

    private static String bin_to_hex(int value, int length) {
        char[] arr = new char[length];
        int ai = arr.length;
        while (ai-- > 0) {
            arr[ai] = HEXCHARS[value & 0xF];
            value >>>= 4;
        }
        return new String(arr);
    }

    private static byte B(int i) {
        return (byte)(i & 0xFF);
    }

    private static short S(int i) {
        return (short)(i & 0xFFFF);
    }

    public UUID(rpc.uuid_t uuid) {
        this.time_low = uuid.time_low;
        this.time_mid = uuid.time_mid;
        this.time_hi_and_version = uuid.time_hi_and_version;
        this.clock_seq_hi_and_reserved = uuid.clock_seq_hi_and_reserved;
        this.clock_seq_low = uuid.clock_seq_low;
        this.node = new byte[6];
        this.node[0] = uuid.node[0];
        this.node[1] = uuid.node[1];
        this.node[2] = uuid.node[2];
        this.node[3] = uuid.node[3];
        this.node[4] = uuid.node[4];
        this.node[5] = uuid.node[5];
    }

    public UUID(String str) {
        char[] arr = str.toCharArray();
        this.time_low = UUID.hex_to_bin(arr, 0, 8);
        this.time_mid = UUID.S(UUID.hex_to_bin(arr, 9, 4));
        this.time_hi_and_version = UUID.S(UUID.hex_to_bin(arr, 14, 4));
        this.clock_seq_hi_and_reserved = UUID.B(UUID.hex_to_bin(arr, 19, 2));
        this.clock_seq_low = UUID.B(UUID.hex_to_bin(arr, 21, 2));
        this.node = new byte[6];
        this.node[0] = UUID.B(UUID.hex_to_bin(arr, 24, 2));
        this.node[1] = UUID.B(UUID.hex_to_bin(arr, 26, 2));
        this.node[2] = UUID.B(UUID.hex_to_bin(arr, 28, 2));
        this.node[3] = UUID.B(UUID.hex_to_bin(arr, 30, 2));
        this.node[4] = UUID.B(UUID.hex_to_bin(arr, 32, 2));
        this.node[5] = UUID.B(UUID.hex_to_bin(arr, 34, 2));
    }

    public String toString() {
        return UUID.bin_to_hex(this.time_low, 8) + "-" + UUID.bin_to_hex(this.time_mid, 4) + "-" + UUID.bin_to_hex(this.time_hi_and_version, 4) + "-" + UUID.bin_to_hex(this.clock_seq_hi_and_reserved, 2) + UUID.bin_to_hex(this.clock_seq_low, 2) + "-" + UUID.bin_to_hex(this.node[0], 2) + UUID.bin_to_hex(this.node[1], 2) + UUID.bin_to_hex(this.node[2], 2) + UUID.bin_to_hex(this.node[3], 2) + UUID.bin_to_hex(this.node[4], 2) + UUID.bin_to_hex(this.node[5], 2);
    }
}

