/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.context;

import java.net.MalformedURLException;
import java.net.URLStreamHandler;
import org.codelibs.jcifs.smb.BufferCache;
import org.codelibs.jcifs.smb.CIFSContext;
import org.codelibs.jcifs.smb.CIFSException;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.Credentials;
import org.codelibs.jcifs.smb.DfsResolver;
import org.codelibs.jcifs.smb.NameServiceClient;
import org.codelibs.jcifs.smb.SidResolver;
import org.codelibs.jcifs.smb.SmbPipeResource;
import org.codelibs.jcifs.smb.SmbResource;
import org.codelibs.jcifs.smb.SmbTransportPool;
import org.codelibs.jcifs.smb.impl.Handler;
import org.codelibs.jcifs.smb.impl.SmbFile;
import org.codelibs.jcifs.smb.impl.SmbNamedPipe;

public class CIFSContextWrapper
implements CIFSContext {
    private final CIFSContext delegate;
    private Handler wrappedHandler;

    public CIFSContextWrapper(CIFSContext delegate) {
        this.delegate = delegate;
    }

    @Override
    public SmbResource get(String url) throws CIFSException {
        try {
            return new SmbFile(url, (CIFSContext)this);
        }
        catch (MalformedURLException e) {
            throw new CIFSException("Invalid URL " + url, e);
        }
    }

    @Override
    public SmbPipeResource getPipe(String url, int pipeType) throws CIFSException {
        try {
            return new SmbNamedPipe(url, pipeType, this);
        }
        catch (MalformedURLException e) {
            throw new CIFSException("Invalid URL " + url, e);
        }
    }

    protected CIFSContext wrap(CIFSContext newContext) {
        return newContext;
    }

    @Override
    public Configuration getConfig() {
        return this.delegate.getConfig();
    }

    @Override
    public DfsResolver getDfs() {
        return this.delegate.getDfs();
    }

    @Override
    public Credentials getCredentials() {
        return this.delegate.getCredentials();
    }

    @Override
    public URLStreamHandler getUrlHandler() {
        if (this.wrappedHandler == null) {
            this.wrappedHandler = new Handler(this);
        }
        return this.wrappedHandler;
    }

    @Override
    public SidResolver getSIDResolver() {
        return this.delegate.getSIDResolver();
    }

    @Override
    public boolean hasDefaultCredentials() {
        return this.delegate.hasDefaultCredentials();
    }

    @Override
    public CIFSContext withCredentials(Credentials creds) {
        return this.wrap(this.delegate.withCredentials(creds));
    }

    @Override
    public CIFSContext withDefaultCredentials() {
        return this.wrap(this.delegate.withDefaultCredentials());
    }

    @Override
    public CIFSContext withAnonymousCredentials() {
        return this.wrap(this.delegate.withAnonymousCredentials());
    }

    @Override
    public CIFSContext withGuestCredentials() {
        return this.wrap(this.delegate.withGuestCredentials());
    }

    @Override
    public boolean renewCredentials(String locationHint, Throwable error) {
        return this.delegate.renewCredentials(locationHint, error);
    }

    @Override
    public NameServiceClient getNameServiceClient() {
        return this.delegate.getNameServiceClient();
    }

    @Override
    public BufferCache getBufferCache() {
        return this.delegate.getBufferCache();
    }

    @Override
    public SmbTransportPool getTransportPool() {
        return this.delegate.getTransportPool();
    }

    @Override
    public boolean close() throws CIFSException {
        return this.delegate.close();
    }
}

