/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.context;

import org.codelibs.jcifs.smb.CIFSContext;
import org.codelibs.jcifs.smb.Credentials;
import org.codelibs.jcifs.smb.context.AbstractCIFSContext;
import org.codelibs.jcifs.smb.context.CIFSContextWrapper;
import org.codelibs.jcifs.smb.impl.CredentialsInternal;
import org.codelibs.jcifs.smb.impl.NtlmAuthenticator;
import org.codelibs.jcifs.smb.impl.NtlmPasswordAuthenticator;
import org.codelibs.jcifs.smb.impl.SmbAuthException;
import org.codelibs.jcifs.smb.impl.SmbRenewableCredentials;

public final class CIFSContextCredentialWrapper
extends CIFSContextWrapper
implements CIFSContext {
    private Credentials creds;

    public CIFSContextCredentialWrapper(AbstractCIFSContext delegate, Credentials creds) {
        super(delegate);
        this.creds = creds;
    }

    @Override
    public Credentials getCredentials() {
        return this.creds;
    }

    @Override
    public boolean renewCredentials(String locationHint, Throwable error) {
        SmbAuthException s;
        NtlmPasswordAuthenticator newAuth;
        SmbRenewableCredentials renewable;
        CredentialsInternal renewed;
        Credentials cred = this.getCredentials();
        if (cred instanceof SmbRenewableCredentials && (renewed = (renewable = (SmbRenewableCredentials)cred).renew()) != null) {
            this.creds = renewed;
            return true;
        }
        NtlmAuthenticator auth = NtlmAuthenticator.getDefault();
        if (auth != null && (newAuth = NtlmAuthenticator.requestNtlmPasswordAuthentication(auth, locationHint, error instanceof SmbAuthException ? (s = (SmbAuthException)error) : null)) != null) {
            this.creds = newAuth;
            return true;
        }
        return false;
    }
}

