/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb;

import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.List;
import java.util.TimeZone;
import org.codelibs.jcifs.smb.DialectVersion;
import org.codelibs.jcifs.smb.ResolverType;

public interface Configuration {
    public SecureRandom getRandom();

    public long getDfsTtl();

    public boolean isDfsStrictView();

    public boolean isDfsDisabled();

    public boolean isDfsConvertToFQDN();

    public boolean isPreserveShareCase();

    public DialectVersion getMinimumVersion();

    public DialectVersion getMaximumVersion();

    public boolean isUseSMB2OnlyNegotiation();

    public boolean isRequireSecureNegotiate();

    public boolean isPort139FailoverEnabled();

    public boolean isUseUnicode();

    public boolean isForceUnicode();

    public boolean isUseBatching();

    public String getNativeOs();

    public String getNativeLanman();

    @Deprecated
    public int getRecieveBufferSize();

    public int getReceiveBufferSize();

    public int getSendBufferSize();

    public int getSoTimeout();

    public int getConnTimeout();

    public int getSessionTimeout();

    public int getResponseTimeout();

    public int getLocalPort();

    public InetAddress getLocalAddr();

    public String getNetbiosHostname();

    public String getLogonShare();

    public String getDefaultDomain();

    public String getDefaultUsername();

    public String getDefaultPassword();

    public int getLanManCompatibility();

    public boolean isAllowNTLMFallback();

    public boolean isUseRawNTLM();

    public boolean isDisablePlainTextPasswords();

    public List<ResolverType> getResolveOrder();

    public InetAddress getBroadcastAddress();

    public InetAddress[] getWinsServers();

    public int getNetbiosLocalPort();

    public InetAddress getNetbiosLocalAddress();

    public int getNetbiosSoTimeout();

    public int getVcNumber();

    public int getCapabilities();

    public int getFlags2();

    public int getSessionLimit();

    public String getOemEncoding();

    public TimeZone getLocalTimezone();

    public int getPid();

    public int getMaxMpxCount();

    public boolean isSigningEnabled();

    public boolean isIpcSigningEnforced();

    public boolean isSigningEnforced();

    public boolean isEncryptionEnabled();

    public boolean isForceExtendedSecurity();

    public String getLmHostsFileName();

    public String getNetbiosScope();

    public int getNetbiosSndBufSize();

    public int getNetbiosRcvBufSize();

    public int getNetbiosRetryTimeout();

    public int getNetbiosRetryCount();

    public int getNetbiosCachePolicy();

    public int getMaximumBufferSize();

    public int getTransactionBufferSize();

    public int getBufferCacheSize();

    public int getListCount();

    public int getListSize();

    public long getAttributeCacheTimeout();

    public boolean isIgnoreCopyToException();

    public int getBatchLimit(String var1);

    public int getNotifyBufferSize();

    public int getMaxRequestRetries();

    public boolean isStrictResourceLifecycle();

    public boolean isTraceResourceUsage();

    public boolean isAllowCompound(String var1);

    public byte[] getMachineId();

    public boolean isDisableSpnegoIntegrity();

    public boolean isEnforceSpnegoIntegrity();

    public boolean isSendNTLMTargetName();

    public String getGuestPassword();

    public String getGuestUsername();

    public boolean isAllowGuestFallback();
}

