/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb1.netbios;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class SocketOutputStream
extends FilterOutputStream {
    SocketOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (len > 65535) {
            throw new IOException("write too large: " + len);
        }
        if (off < 4) {
            throw new IOException("NetBIOS socket output buffer requires 4 bytes available before off");
        }
        b[(off -= 4) + 0] = 0;
        b[off + 1] = 0;
        b[off + 2] = (byte)(len >> 8 & 0xFF);
        b[off + 3] = (byte)(len & 0xFF);
        this.out.write(b, off, 4 + len);
    }
}

