/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb1.netbios;

import java.io.IOException;
import java.io.InputStream;
import org.codelibs.jcifs.smb1.netbios.Name;
import org.codelibs.jcifs.smb1.netbios.SessionServicePacket;

public class SessionRequestPacket
extends SessionServicePacket {
    private final Name calledName;
    private final Name callingName;

    SessionRequestPacket() {
        this.calledName = new Name();
        this.callingName = new Name();
    }

    public SessionRequestPacket(Name calledName, Name callingName) {
        this.type = 129;
        this.calledName = calledName;
        this.callingName = callingName;
    }

    @Override
    int writeTrailerWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        dstIndex += this.calledName.writeWireFormat(dst, dstIndex);
        dstIndex += this.callingName.writeWireFormat(dst, dstIndex);
        return dstIndex - start;
    }

    @Override
    int readTrailerWireFormat(InputStream in, byte[] buffer, int bufferIndex) throws IOException {
        int start = bufferIndex;
        if (in.read(buffer, bufferIndex, this.length) != this.length) {
            throw new IOException("invalid session request wire format");
        }
        bufferIndex += this.calledName.readWireFormat(buffer, bufferIndex);
        bufferIndex += this.callingName.readWireFormat(buffer, bufferIndex);
        return bufferIndex - start;
    }
}

