/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb1;

import java.io.IOException;
import java.io.InputStream;
import org.codelibs.jcifs.smb1.SmbFile;

public class TestLocking
implements Runnable {
    int numThreads = 1;
    int numIter = 1;
    long delay = 100L;
    String url = null;
    int numComplete = 0;
    long ltime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            SmbFile f = new SmbFile(this.url);
            SmbFile d = new SmbFile(f.getParent());
            byte[] buf = new byte[1024];
            for (int ii = 0; ii < this.numIter; ++ii) {
                TestLocking testLocking = this;
                synchronized (testLocking) {
                    this.ltime = System.currentTimeMillis();
                    this.wait();
                }
                try {
                    double r = Math.random();
                    if (r < 0.333) {
                        f.exists();
                        continue;
                    }
                    if (r < 0.667) {
                        d.listFiles();
                        continue;
                    }
                    if (!(r < 1.0)) continue;
                    InputStream in = f.getInputStream();
                    while (in.read(buf) > 0) {
                    }
                    in.close();
                    continue;
                }
                catch (IOException ioe) {
                    System.err.println(ioe.getMessage());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ++this.numComplete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int ti;
        if (args.length < 1) {
            System.err.println("usage: TestLocking [-t <numThreads>] [-i <numIter>] [-d <delay>] url");
            System.exit(1);
        }
        TestLocking t = new TestLocking();
        t.ltime = System.currentTimeMillis();
        for (int ai = 0; ai < args.length; ++ai) {
            if (args[ai].equals("-t")) {
                t.numThreads = Integer.parseInt(args[++ai]);
                continue;
            }
            if (args[ai].equals("-i")) {
                t.numIter = Integer.parseInt(args[++ai]);
                continue;
            }
            if (args[ai].equals("-d")) {
                t.delay = Long.parseLong(args[++ai]);
                continue;
            }
            t.url = args[ai];
        }
        Thread[] threads = new Thread[t.numThreads];
        for (ti = 0; ti < t.numThreads; ++ti) {
            threads[ti] = new Thread(t);
            System.out.print(threads[ti].getName());
            threads[ti].start();
        }
        while (t.numComplete < t.numThreads) {
            TestLocking testLocking;
            long delay;
            do {
                delay = 2L;
                testLocking = t;
                synchronized (testLocking) {
                    long expire = t.ltime + t.delay;
                    long ctime = System.currentTimeMillis();
                    if (expire > ctime) {
                        delay = expire - ctime;
                    }
                }
                if (delay > 2L) {
                    System.out.println("delay=" + delay);
                }
                Thread.sleep(delay);
            } while (delay > 2L);
            testLocking = t;
            synchronized (testLocking) {
                t.notifyAll();
            }
        }
        for (ti = 0; ti < t.numThreads; ++ti) {
            threads[ti].join();
            System.out.print(threads[ti].getName());
        }
        System.out.println();
    }
}

