/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb1;

import org.codelibs.jcifs.smb1.ServerMessageBlock;
import org.codelibs.jcifs.smb1.SmbComTransaction;
import org.codelibs.jcifs.smb1.SmbComTreeConnectAndX;
import org.codelibs.jcifs.smb1.SmbComTreeConnectAndXResponse;
import org.codelibs.jcifs.smb1.SmbComTreeDisconnect;
import org.codelibs.jcifs.smb1.SmbException;
import org.codelibs.jcifs.smb1.SmbSession;
import org.codelibs.jcifs.smb1.SmbTransport;
import org.codelibs.jcifs.smb1.util.LogStream;

class SmbTree {
    private static int tree_conn_counter;
    int connectionState;
    int tid;
    String share;
    String service = "?????";
    String service0;
    SmbSession session;
    boolean inDfs;
    boolean inDomainDfs;
    int tree_num;

    SmbTree(SmbSession session, String share, String service) {
        this.session = session;
        this.share = share.toUpperCase();
        if (service != null && !service.startsWith("??")) {
            this.service = service;
        }
        this.service0 = this.service;
        this.connectionState = 0;
    }

    boolean matches(String share, String service) {
        return this.share.equalsIgnoreCase(share) && (service == null || service.startsWith("??") || this.service.equalsIgnoreCase(service));
    }

    public boolean equals(Object obj) {
        if (obj instanceof SmbTree) {
            SmbTree tree = (SmbTree)obj;
            return this.matches(tree.share, tree.service);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(ServerMessageBlock request, ServerMessageBlock response) throws SmbException {
        SmbTransport smbTransport = this.session.transport();
        synchronized (smbTransport) {
            if (response != null) {
                response.received = false;
            }
            this.treeConnect(request, response);
            if (request == null || response != null && response.received) {
                return;
            }
            if (!this.service.equals("A:")) {
                block3 : switch (request.command) {
                    case -94: 
                    case 4: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 113: {
                        break;
                    }
                    case 37: 
                    case 50: {
                        switch (((SmbComTransaction)request).subCommand & 0xFF) {
                            case 0: 
                            case 16: 
                            case 35: 
                            case 38: 
                            case 83: 
                            case 84: 
                            case 104: 
                            case 215: {
                                break block3;
                            }
                        }
                        throw new SmbException("Invalid operation for " + this.service + " service");
                    }
                    default: {
                        throw new SmbException("Invalid operation for " + this.service + " service" + String.valueOf(request));
                    }
                }
            }
            request.tid = this.tid;
            if (this.inDfs && !this.service.equals("IPC") && request.path != null && request.path.length() > 0) {
                request.flags2 = 4096;
                request.path = "\\" + this.session.transport().tconHostName + "\\" + this.share + request.path;
            }
            try {
                this.session.send(request, response);
            }
            catch (SmbException se) {
                if (se.getNtStatus() == -1073741623) {
                    this.treeDisconnect(true);
                }
                throw se;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void treeConnect(ServerMessageBlock andx, ServerMessageBlock andxResponse) throws SmbException {
        SmbTransport smbTransport = this.session.transport();
        synchronized (smbTransport) {
            while (this.connectionState != 0) {
                if (this.connectionState == 2 || this.connectionState == 3) {
                    return;
                }
                try {
                    this.session.transport.wait();
                }
                catch (InterruptedException ie) {
                    throw new SmbException(ie.getMessage(), (Throwable)ie);
                }
            }
            this.connectionState = 1;
            try {
                this.session.transport.connect();
                String unc = "\\\\" + this.session.transport.tconHostName + "\\" + this.share;
                this.service = this.service0;
                if (LogStream.level >= 4) {
                    SmbTransport.log.println("treeConnect: unc=" + unc + ",service=" + this.service);
                }
                SmbComTreeConnectAndXResponse response = new SmbComTreeConnectAndXResponse(andxResponse);
                SmbComTreeConnectAndX request = new SmbComTreeConnectAndX(this.session, unc, this.service, andx);
                this.session.send(request, response);
                this.tid = response.tid;
                this.service = response.service;
                this.inDfs = response.shareIsInDfs;
                this.tree_num = tree_conn_counter++;
                this.connectionState = 2;
            }
            catch (SmbException se) {
                this.treeDisconnect(true);
                this.connectionState = 0;
                throw se;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void treeDisconnect(boolean inError) {
        SmbTransport smbTransport = this.session.transport();
        synchronized (smbTransport) {
            block7: {
                if (this.connectionState != 2) {
                    return;
                }
                this.connectionState = 3;
                if (!inError && this.tid != 0) {
                    try {
                        this.send(new SmbComTreeDisconnect(), null);
                    }
                    catch (SmbException se) {
                        if (LogStream.level <= 1) break block7;
                        se.printStackTrace(SmbTransport.log);
                    }
                }
            }
            this.inDfs = false;
            this.inDomainDfs = false;
            this.connectionState = 0;
            this.session.transport.notifyAll();
        }
    }

    public String toString() {
        return "SmbTree[share=" + this.share + ",service=" + this.service + ",tid=" + this.tid + ",inDfs=" + this.inDfs + ",inDomainDfs=" + this.inDomainDfs + ",connectionState=" + this.connectionState + "]";
    }
}

