/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.codelibs.jcifs.smb1.NtlmPasswordAuthentication;
import org.codelibs.jcifs.smb1.SmbFile;
import org.codelibs.jcifs.smb1.SmbFileInputStream;
import org.codelibs.jcifs.smb1.SmbFileOutputStream;
import org.codelibs.jcifs.smb1.TransactNamedPipeInputStream;
import org.codelibs.jcifs.smb1.TransactNamedPipeOutputStream;

public class SmbNamedPipe
extends SmbFile {
    public static final int PIPE_TYPE_RDONLY = 1;
    public static final int PIPE_TYPE_WRONLY = 2;
    public static final int PIPE_TYPE_RDWR = 3;
    public static final int PIPE_TYPE_CALL = 256;
    public static final int PIPE_TYPE_TRANSACT = 512;
    public static final int PIPE_TYPE_DCE_TRANSACT = 1536;
    InputStream pipeIn;
    OutputStream pipeOut;
    int pipeType;

    public SmbNamedPipe(String url, int pipeType) throws MalformedURLException, UnknownHostException {
        super(url);
        this.pipeType = pipeType;
        this.type = 16;
    }

    public SmbNamedPipe(String url, int pipeType, NtlmPasswordAuthentication auth) throws MalformedURLException, UnknownHostException {
        super(url, auth);
        this.pipeType = pipeType;
        this.type = 16;
    }

    public SmbNamedPipe(URL url, int pipeType, NtlmPasswordAuthentication auth) throws MalformedURLException, UnknownHostException {
        super(url, auth);
        this.pipeType = pipeType;
        this.type = 16;
    }

    public InputStream getNamedPipeInputStream() throws IOException {
        if (this.pipeIn == null) {
            this.pipeIn = (this.pipeType & 0x100) == 256 || (this.pipeType & 0x200) == 512 ? new TransactNamedPipeInputStream(this) : new SmbFileInputStream(this, this.pipeType & 0xFFFF00FF | 0x20);
        }
        return this.pipeIn;
    }

    public OutputStream getNamedPipeOutputStream() throws IOException {
        if (this.pipeOut == null) {
            this.pipeOut = (this.pipeType & 0x100) == 256 || (this.pipeType & 0x200) == 512 ? new TransactNamedPipeOutputStream(this) : new SmbFileOutputStream(this, false, this.pipeType & 0xFFFF00FF | 0x20);
        }
        return this.pipeOut;
    }
}

