/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb1;

import org.codelibs.jcifs.smb1.ServerMessageBlock;
import org.codelibs.jcifs.smb1.util.Hexdump;

class SmbComDelete
extends ServerMessageBlock {
    private final int searchAttributes;

    SmbComDelete(String fileName) {
        this.path = fileName;
        this.command = (byte)6;
        this.searchAttributes = 6;
    }

    @Override
    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        SmbComDelete.writeInt2(this.searchAttributes, dst, dstIndex);
        return 2;
    }

    @Override
    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        dst[dstIndex] = 4;
        ++dstIndex;
        dstIndex += this.writeString(this.path, dst, dstIndex);
        return dstIndex - start;
    }

    @Override
    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return "SmbComDelete[" + super.toString() + ",searchAttributes=0x" + Hexdump.toHexString(this.searchAttributes, 4) + ",fileName=" + this.path + "]";
    }
}

