/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb1;

import java.io.UnsupportedEncodingException;
import org.codelibs.jcifs.smb1.NtlmPasswordAuthentication;
import org.codelibs.jcifs.smb1.SmbException;
import org.codelibs.jcifs.smb1.ntlmssp.Type1Message;
import org.codelibs.jcifs.smb1.ntlmssp.Type2Message;
import org.codelibs.jcifs.smb1.ntlmssp.Type3Message;
import org.codelibs.jcifs.smb1.util.Encdec;
import org.codelibs.jcifs.smb1.util.Hexdump;
import org.codelibs.jcifs.smb1.util.LogStream;

public class NtlmContext {
    NtlmPasswordAuthentication auth;
    int ntlmsspFlags;
    String workstation;
    boolean isEstablished = false;
    byte[] serverChallenge = null;
    byte[] signingKey = null;
    String netbiosName = null;
    int state = 1;
    LogStream log;

    public NtlmContext(NtlmPasswordAuthentication auth, boolean doSigning) {
        this.auth = auth;
        this.ntlmsspFlags = this.ntlmsspFlags | 4 | 0x80000 | 0x20000000;
        if (doSigning) {
            this.ntlmsspFlags |= 0x40008010;
        }
        this.workstation = Type1Message.getDefaultWorkstation();
        this.log = LogStream.getInstance();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder("NtlmContext[auth=").append(this.auth).append(",ntlmsspFlags=0x").append(Hexdump.toHexString(this.ntlmsspFlags, 8)).append(",workstation=").append(this.workstation).append(",isEstablished=").append(this.isEstablished).append(",state=").append(this.state).append(",serverChallenge=");
        if (this.serverChallenge == null) {
            ret.append("null");
        } else {
            ret.append(Hexdump.toHexString(this.serverChallenge, 0, this.serverChallenge.length * 2));
        }
        ret.append(",signingKey=");
        if (this.signingKey == null) {
            ret.append("null");
        } else {
            ret.append(Hexdump.toHexString(this.signingKey, 0, this.signingKey.length * 2));
        }
        ret.append("]");
        return ret.toString();
    }

    public boolean isEstablished() {
        return this.isEstablished;
    }

    public byte[] getServerChallenge() {
        return this.serverChallenge;
    }

    public byte[] getSigningKey() {
        return this.signingKey;
    }

    public String getNetbiosName() {
        return this.netbiosName;
    }

    private String getNtlmsspListItem(byte[] type2token, int id0) {
        int ri = 58;
        while (true) {
            short id = Encdec.dec_uint16le(type2token, ri);
            short len = Encdec.dec_uint16le(type2token, ri + 2);
            if (id == 0 || (ri += 4) + len > type2token.length) break;
            if (id == id0) {
                try {
                    return new String(type2token, ri, (int)len, "UTF-16LE");
                }
                catch (UnsupportedEncodingException uee) {
                    break;
                }
            }
            ri += len;
        }
        return null;
    }

    public byte[] initSecContext(byte[] token, int offset, int len) throws SmbException {
        switch (this.state) {
            case 1: {
                Type1Message msg1 = new Type1Message(this.ntlmsspFlags, this.auth.getDomain(), this.workstation);
                token = msg1.toByteArray();
                if (LogStream.level >= 4) {
                    this.log.println(msg1);
                    if (LogStream.level >= 6) {
                        Hexdump.hexdump(this.log, token, 0, token.length);
                    }
                }
                ++this.state;
                break;
            }
            case 2: {
                try {
                    Type2Message msg2 = new Type2Message(token);
                    if (LogStream.level >= 4) {
                        this.log.println(msg2);
                        if (LogStream.level >= 6) {
                            Hexdump.hexdump(this.log, token, 0, token.length);
                        }
                    }
                    this.serverChallenge = msg2.getChallenge();
                    this.ntlmsspFlags &= msg2.getFlags();
                    Type3Message msg3 = new Type3Message(msg2, this.auth.getPassword(), this.auth.getDomain(), this.auth.getUsername(), this.workstation, this.ntlmsspFlags);
                    token = msg3.toByteArray();
                    if (LogStream.level >= 4) {
                        this.log.println(msg3);
                        if (LogStream.level >= 6) {
                            Hexdump.hexdump(this.log, token, 0, token.length);
                        }
                    }
                    if ((this.ntlmsspFlags & 0x10) != 0) {
                        this.signingKey = msg3.getMasterKey();
                    }
                    this.isEstablished = true;
                    ++this.state;
                    break;
                }
                catch (Exception e) {
                    throw new SmbException(e.getMessage(), (Throwable)e);
                }
            }
            default: {
                throw new SmbException("Invalid state");
            }
        }
        return token;
    }
}

