/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.util;

import java.security.MessageDigest;
import org.codelibs.jcifs.smb.util.Crypto;

class HMACT64
extends MessageDigest
implements Cloneable {
    private static final int BLOCK_LENGTH = 64;
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;
    private final MessageDigest md5;
    private byte[] ipad = new byte[64];
    private byte[] opad = new byte[64];

    public HMACT64(byte[] key) {
        super("HMACT64");
        int i;
        int length = Math.min(key.length, 64);
        for (i = 0; i < length; ++i) {
            this.ipad[i] = (byte)(key[i] ^ 0x36);
            this.opad[i] = (byte)(key[i] ^ 0x5C);
        }
        for (i = length; i < 64; ++i) {
            this.ipad[i] = 54;
            this.opad[i] = 92;
        }
        this.md5 = Crypto.getMD5();
        this.engineReset();
    }

    private HMACT64(HMACT64 hmac) throws CloneNotSupportedException {
        super("HMACT64");
        this.ipad = hmac.ipad;
        this.opad = hmac.opad;
        this.md5 = (MessageDigest)hmac.md5.clone();
    }

    @Override
    public Object clone() {
        try {
            return new HMACT64(this);
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    @Override
    protected byte[] engineDigest() {
        byte[] digest = this.md5.digest();
        this.md5.update(this.opad);
        return this.md5.digest(digest);
    }

    @Override
    protected int engineDigest(byte[] buf, int offset, int len) {
        byte[] digest = this.md5.digest();
        this.md5.update(this.opad);
        this.md5.update(digest);
        try {
            return this.md5.digest(buf, offset, len);
        }
        catch (Exception ex) {
            throw new IllegalStateException();
        }
    }

    @Override
    protected int engineGetDigestLength() {
        return this.md5.getDigestLength();
    }

    @Override
    protected void engineReset() {
        this.md5.reset();
        this.md5.update(this.ipad);
    }

    @Override
    protected void engineUpdate(byte b) {
        this.md5.update(b);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        this.md5.update(input, offset, len);
    }
}

