/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.netbios;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.codelibs.jcifs.smb.Address;
import org.codelibs.jcifs.smb.CIFSContext;
import org.codelibs.jcifs.smb.netbios.NbtAddress;

public class UniAddress
implements Address {
    Object addr;
    String calledName;

    public static boolean isDotQuadIP(String hostname) {
        if (Character.isDigit(hostname.charAt(0))) {
            int dots = 0;
            int i = 0;
            int len = hostname.length();
            char[] data = hostname.toCharArray();
            while (i < len && Character.isDigit(data[i++])) {
                if (i == len && dots == 3) {
                    return true;
                }
                if (i >= len || data[i] != '.') continue;
                ++dots;
                ++i;
            }
        }
        return false;
    }

    public UniAddress(Object addr) {
        if (addr == null) {
            throw new IllegalArgumentException();
        }
        this.addr = addr;
    }

    public int hashCode() {
        return this.addr.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof UniAddress && this.addr.equals(((UniAddress)obj).addr);
    }

    @Override
    public String firstCalledName() {
        int i;
        if (this.addr instanceof NbtAddress) {
            return ((NbtAddress)this.addr).firstCalledName();
        }
        this.calledName = ((InetAddress)this.addr).getHostName();
        this.calledName = UniAddress.isDotQuadIP(this.calledName) ? "*SMBSERVER     " : ((i = this.calledName.indexOf(46)) > 1 && i < 15 ? this.calledName.substring(0, i).toUpperCase() : (this.calledName.length() > 15 ? "*SMBSERVER     " : this.calledName.toUpperCase()));
        return this.calledName;
    }

    @Override
    public String nextCalledName(CIFSContext tc) {
        if (this.addr instanceof NbtAddress) {
            return ((NbtAddress)this.addr).nextCalledName(tc);
        }
        if (this.calledName != "*SMBSERVER     ") {
            this.calledName = "*SMBSERVER     ";
            return this.calledName;
        }
        return null;
    }

    public Object getAddress() {
        return this.addr;
    }

    @Override
    public String getHostName() {
        if (this.addr instanceof NbtAddress) {
            return ((NbtAddress)this.addr).getHostName();
        }
        return ((InetAddress)this.addr).getHostName();
    }

    @Override
    public String getHostAddress() {
        if (this.addr instanceof NbtAddress) {
            return ((NbtAddress)this.addr).getHostAddress();
        }
        return ((InetAddress)this.addr).getHostAddress();
    }

    @Override
    public InetAddress toInetAddress() throws UnknownHostException {
        if (this.addr instanceof Address) {
            return ((Address)this.addr).toInetAddress();
        }
        if (this.addr instanceof InetAddress) {
            return (InetAddress)this.addr;
        }
        return null;
    }

    @Override
    public <T extends Address> T unwrap(Class<T> type) {
        if (this.addr instanceof Address) {
            return ((Address)this.addr).unwrap(type);
        }
        if (this.getClass().isAssignableFrom(type)) {
            return (T)this;
        }
        return null;
    }

    public String toString() {
        return this.addr.toString();
    }
}

