/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.util;

public class SMBUtil {
    public static final byte[] SMB_HEADER = new byte[]{-1, 83, 77, 66, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] SMB2_HEADER = new byte[]{-2, 83, 77, 66, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    private SMBUtil() {
    }

    public static void writeInt2(long val, byte[] dst, int dstIndex) {
        dst[dstIndex] = (byte)val;
        dst[++dstIndex] = (byte)(val >> 8);
    }

    public static void writeInt4(long val, byte[] dst, int dstIndex) {
        dst[dstIndex] = (byte)val;
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >> 8);
    }

    public static int readInt2(byte[] src, int srcIndex) {
        return (src[srcIndex] & 0xFF) + ((src[srcIndex + 1] & 0xFF) << 8);
    }

    public static int readInt4(byte[] src, int srcIndex) {
        return (src[srcIndex] & 0xFF) + ((src[srcIndex + 1] & 0xFF) << 8) + ((src[srcIndex + 2] & 0xFF) << 16) + ((src[srcIndex + 3] & 0xFF) << 24);
    }

    public static long readInt8(byte[] src, int srcIndex) {
        return ((long)SMBUtil.readInt4(src, srcIndex) & 0xFFFFFFFFL) + ((long)SMBUtil.readInt4(src, srcIndex + 4) << 32);
    }

    public static void writeInt8(long val, byte[] dst, int dstIndex) {
        dst[dstIndex] = (byte)val;
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >> 8);
    }

    public static long readTime(byte[] src, int srcIndex) {
        int low = SMBUtil.readInt4(src, srcIndex);
        int hi = SMBUtil.readInt4(src, srcIndex + 4);
        long t = (long)hi << 32 | (long)low & 0xFFFFFFFFL;
        return t / 10000L - 11644473600000L;
    }

    public static void writeTime(long t, byte[] dst, int dstIndex) {
        if (t != 0L) {
            t = (t + 11644473600000L) * 10000L;
        }
        SMBUtil.writeInt8(t, dst, dstIndex);
    }

    public static long readUTime(byte[] buffer, int bufferIndex) {
        return ((long)SMBUtil.readInt4(buffer, bufferIndex) & 0xFFFFFFFFL) * 1000L;
    }

    public static void writeUTime(long t, byte[] dst, int dstIndex) {
        SMBUtil.writeInt4(t / 1000L, dst, dstIndex);
    }
}

