/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb2.lock;

import org.codelibs.jcifs.smb.Encodable;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class Smb2Lock
implements Encodable {
    public static final int SMB2_LOCKFLAG_SHARED_LOCK = 1;
    public static final int SMB2_LOCKFLAG_EXCLUSIVE_LOCK = 2;
    public static final int SMB2_LOCKFLAG_UNLOCK = 4;
    public static final int SMB2_LOCKFLAG_FAIL_IMMEDIATELY = 16;
    private final long offset;
    private final long length;
    private final int flags;

    public Smb2Lock(long offset, long length, int flags) {
        this.offset = offset;
        this.length = length;
        this.flags = flags;
    }

    @Override
    public int size() {
        return 24;
    }

    @Override
    public int encode(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt8(this.offset, dst, dstIndex);
        SMBUtil.writeInt8(this.length, dst, dstIndex += 8);
        SMBUtil.writeInt4(this.flags, dst, dstIndex += 8);
        dstIndex += 4;
        return (dstIndex += 4) - start;
    }
}

