/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb2.info;

import org.codelibs.jcifs.smb.CIFSException;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.Decodable;
import org.codelibs.jcifs.smb.internal.SMBProtocolDecodingException;
import org.codelibs.jcifs.smb.internal.dtyp.SecurityDescriptor;
import org.codelibs.jcifs.smb.internal.fscc.FileFsFullSizeInformation;
import org.codelibs.jcifs.smb.internal.fscc.FileFsSizeInformation;
import org.codelibs.jcifs.smb.internal.fscc.FileInternalInfo;
import org.codelibs.jcifs.smb.internal.smb2.ServerMessageBlock2Response;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class Smb2QueryInfoResponse
extends ServerMessageBlock2Response {
    public static final int OVERHEAD = 72;
    private final byte expectInfoType;
    private final byte expectInfoClass;
    private Decodable info;

    public Smb2QueryInfoResponse(Configuration config, byte expectInfoType, byte expectInfoClass) {
        super(config);
        this.expectInfoType = expectInfoType;
        this.expectInfoClass = expectInfoClass;
    }

    public Decodable getInfo() {
        return this.info;
    }

    public <T extends Decodable> T getInfo(Class<T> clazz) throws CIFSException {
        if (!clazz.isAssignableFrom(this.info.getClass())) {
            throw new CIFSException("Incompatible file information class");
        }
        return (T)this.getInfo();
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        int structureSize = SMBUtil.readInt2(buffer, bufferIndex);
        if (structureSize != 9) {
            throw new SMBProtocolDecodingException("Expected structureSize = 9");
        }
        int bufferOffset = SMBUtil.readInt2(buffer, bufferIndex + 2) + this.getHeaderStart();
        int bufferLength = SMBUtil.readInt4(buffer, bufferIndex += 4);
        bufferIndex += 4;
        Decodable i = Smb2QueryInfoResponse.createInformation(this.expectInfoType, this.expectInfoClass);
        if (i != null) {
            i.decode(buffer, bufferOffset, bufferLength);
        }
        bufferIndex = Math.max(bufferIndex, bufferOffset + bufferLength);
        this.info = i;
        return bufferIndex - start;
    }

    private static Decodable createInformation(byte infoType, byte infoClass) throws SMBProtocolDecodingException {
        return switch (infoType) {
            case 1 -> Smb2QueryInfoResponse.createFileInformation(infoClass);
            case 2 -> Smb2QueryInfoResponse.createFilesystemInformation(infoClass);
            case 4 -> Smb2QueryInfoResponse.createQuotaInformation(infoClass);
            case 3 -> Smb2QueryInfoResponse.createSecurityInformation(infoClass);
            default -> throw new SMBProtocolDecodingException("Unknwon information type " + infoType);
        };
    }

    private static Decodable createFilesystemInformation(byte infoClass) throws SMBProtocolDecodingException {
        return switch (infoClass) {
            case 7 -> new FileFsFullSizeInformation();
            case 3 -> new FileFsSizeInformation();
            default -> throw new SMBProtocolDecodingException("Unknown filesystem info class " + infoClass);
        };
    }

    private static Decodable createSecurityInformation(byte infoClass) throws SMBProtocolDecodingException {
        return new SecurityDescriptor();
    }

    private static Decodable createQuotaInformation(byte infoClass) throws SMBProtocolDecodingException {
        switch (infoClass) {
            default: 
        }
        throw new SMBProtocolDecodingException("Unknown quota info class " + infoClass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Decodable createFileInformation(byte infoClass) throws SMBProtocolDecodingException {
        switch (infoClass) {
            case 6: {
                return new FileInternalInfo();
            }
            default: {
                throw new SMBProtocolDecodingException("Unknown file info class " + infoClass);
            }
        }
    }
}

