/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb2;

import org.codelibs.jcifs.smb.Encodable;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class Smb2TransformHeader
implements Encodable {
    public static final int TRANSFORM_PROTOCOL_ID = -44872382;
    public static final int TRANSFORM_HEADER_SIZE = 52;
    private final byte[] signature = new byte[16];
    private final byte[] nonce = new byte[16];
    private int originalMessageSize;
    private int flags;
    private long sessionId;

    public Smb2TransformHeader() {
    }

    public Smb2TransformHeader(byte[] nonce, int originalMessageSize, int flags, long sessionId) {
        if (nonce.length != 16) {
            throw new IllegalArgumentException("Nonce must be 16 bytes");
        }
        System.arraycopy(nonce, 0, this.nonce, 0, 16);
        this.originalMessageSize = originalMessageSize;
        this.flags = flags;
        this.sessionId = sessionId;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        if (signature.length != 16) {
            throw new IllegalArgumentException("Signature must be 16 bytes");
        }
        System.arraycopy(signature, 0, this.signature, 0, 16);
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public void setNonce(byte[] nonce) {
        if (nonce.length != 16) {
            throw new IllegalArgumentException("Nonce must be 16 bytes");
        }
        System.arraycopy(nonce, 0, this.nonce, 0, 16);
    }

    public int getOriginalMessageSize() {
        return this.originalMessageSize;
    }

    public void setOriginalMessageSize(int originalMessageSize) {
        this.originalMessageSize = originalMessageSize;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public int size() {
        return 52;
    }

    @Override
    public int encode(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt4(-44872382L, dst, dstIndex);
        System.arraycopy(this.signature, 0, dst, dstIndex += 4, 16);
        System.arraycopy(this.nonce, 0, dst, dstIndex += 16, 16);
        SMBUtil.writeInt4(this.originalMessageSize, dst, dstIndex += 16);
        SMBUtil.writeInt2(0L, dst, dstIndex += 4);
        SMBUtil.writeInt2(this.flags, dst, dstIndex += 2);
        SMBUtil.writeInt8(this.sessionId, dst, dstIndex += 2);
        return (dstIndex += 8) - start;
    }

    public static Smb2TransformHeader decode(byte[] buffer, int bufferIndex) {
        Smb2TransformHeader header = new Smb2TransformHeader();
        int protocolId = SMBUtil.readInt4(buffer, bufferIndex);
        if (protocolId != -44872382) {
            throw new IllegalArgumentException("Invalid transform header protocol ID: 0x" + Integer.toHexString(protocolId));
        }
        System.arraycopy(buffer, bufferIndex += 4, header.signature, 0, 16);
        System.arraycopy(buffer, bufferIndex += 16, header.nonce, 0, 16);
        header.originalMessageSize = SMBUtil.readInt4(buffer, bufferIndex += 16);
        bufferIndex += 4;
        header.flags = SMBUtil.readInt2(buffer, bufferIndex += 2);
        header.sessionId = SMBUtil.readInt8(buffer, bufferIndex += 2);
        return header;
    }

    public byte[] getAssociatedData() {
        byte[] aad = new byte[52];
        int index = 0;
        SMBUtil.writeInt4(-44872382L, aad, index);
        index += 4;
        System.arraycopy(this.nonce, 0, aad, index += 16, 16);
        SMBUtil.writeInt4(this.originalMessageSize, aad, index += 16);
        SMBUtil.writeInt2(0L, aad, index += 4);
        SMBUtil.writeInt2(this.flags, aad, index += 2);
        SMBUtil.writeInt8(this.sessionId, aad, index += 2);
        return aad;
    }
}

