/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb2;

import org.codelibs.jcifs.smb.CIFSContext;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.CommonServerMessageBlockRequest;
import org.codelibs.jcifs.smb.internal.CommonServerMessageBlockResponse;
import org.codelibs.jcifs.smb.internal.Request;
import org.codelibs.jcifs.smb.internal.smb2.ServerMessageBlock2;
import org.codelibs.jcifs.smb.internal.smb2.ServerMessageBlock2Response;
import org.codelibs.jcifs.smb.internal.smb2.Smb2CancelRequest;

public abstract class ServerMessageBlock2Request<T extends ServerMessageBlock2Response>
extends ServerMessageBlock2
implements CommonServerMessageBlockRequest,
Request<T> {
    private T response;
    private Integer overrideTimeout;

    protected ServerMessageBlock2Request(Configuration config) {
        super(config);
    }

    public ServerMessageBlock2Request(Configuration config, int command) {
        super(config, command);
    }

    @Override
    public ServerMessageBlock2Request<T> ignoreDisconnect() {
        return this;
    }

    @Override
    public ServerMessageBlock2Request<?> getNext() {
        return (ServerMessageBlock2Request)super.getNext();
    }

    @Override
    public boolean isCancel() {
        return false;
    }

    @Override
    public boolean isResponseAsync() {
        return this.getAsyncId() != 0L;
    }

    @Override
    public boolean allowChain(CommonServerMessageBlockRequest next) {
        return this.getConfig().isAllowCompound(this.getClass().getSimpleName()) && this.getConfig().isAllowCompound(next.getClass().getSimpleName());
    }

    @Override
    public CommonServerMessageBlockRequest createCancel() {
        return new Smb2CancelRequest(this.getConfig(), this.getMid(), this.getAsyncId());
    }

    @Override
    public CommonServerMessageBlockRequest split() {
        ServerMessageBlock2 n = this.getNext();
        if (n != null) {
            this.setNext(null);
            n.clearFlags(4);
        }
        return n;
    }

    public void setNext(ServerMessageBlock2Request<?> next) {
        super.setNext(next);
    }

    @Override
    public int getCreditCost() {
        return 1;
    }

    @Override
    public void setRequestCredits(int credits) {
        this.setCredit(credits);
    }

    @Override
    public final Integer getOverrideTimeout() {
        return this.overrideTimeout;
    }

    public final void setOverrideTimeout(Integer overrideTimeout) {
        this.overrideTimeout = overrideTimeout;
    }

    @Override
    public T initResponse(CIFSContext tc) {
        T resp = this.createResponse(tc, this);
        if (resp == null) {
            return null;
        }
        ((ServerMessageBlock2)resp).setDigest(this.getDigest());
        this.setResponse((CommonServerMessageBlockResponse)resp);
        ServerMessageBlock2 n = this.getNext();
        if (n instanceof ServerMessageBlock2Request) {
            ((ServerMessageBlock2)resp).setNext((ServerMessageBlock2)((Object)((ServerMessageBlock2Request)n).initResponse(tc)));
        }
        return resp;
    }

    @Override
    public void setTid(int t) {
        this.setTreeId(t);
    }

    @Override
    public int encode(byte[] dst, int dstIndex) {
        int actual;
        int len = super.encode(dst, dstIndex);
        int exp = this.size();
        if (exp != (actual = this.getLength())) {
            throw new IllegalStateException(String.format("Wrong size calculation have %d expect %d", exp, actual));
        }
        return len;
    }

    @Override
    public T getResponse() {
        return this.response;
    }

    protected abstract T createResponse(CIFSContext var1, ServerMessageBlock2Request<T> var2);

    @Override
    public final void setResponse(CommonServerMessageBlockResponse msg) {
        if (msg != null && !(msg instanceof ServerMessageBlock2)) {
            throw new IllegalArgumentException("Incompatible response");
        }
        this.response = (ServerMessageBlock2Response)msg;
    }
}

