/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.trans2;

import org.codelibs.jcifs.smb.CIFSException;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.SMBProtocolDecodingException;
import org.codelibs.jcifs.smb.internal.fscc.FileBasicInfo;
import org.codelibs.jcifs.smb.internal.fscc.FileInformation;
import org.codelibs.jcifs.smb.internal.fscc.FileInternalInfo;
import org.codelibs.jcifs.smb.internal.fscc.FileStandardInfo;
import org.codelibs.jcifs.smb.internal.smb1.trans.SmbComTransactionResponse;

public class Trans2QueryPathInformationResponse
extends SmbComTransactionResponse {
    private final int informationLevel;
    private FileInformation info;

    public Trans2QueryPathInformationResponse(Configuration config, int informationLevel) {
        super(config);
        this.informationLevel = informationLevel;
        this.setSubCommand((byte)5);
    }

    public final FileInformation getInfo() {
        return this.info;
    }

    public <T extends FileInformation> T getInfo(Class<T> type) throws CIFSException {
        if (!type.isAssignableFrom(this.info.getClass())) {
            throw new CIFSException("Incompatible file information class");
        }
        return (T)this.info;
    }

    @Override
    protected int writeSetupWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeParametersWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 2;
    }

    @Override
    protected int readDataWireFormat(byte[] buffer, int bufferIndex, int len) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        FileInformation inf = this.createFileInformation();
        if (inf != null) {
            bufferIndex += inf.decode(buffer, bufferIndex, this.getDataCount());
            this.info = inf;
        }
        return bufferIndex - start;
    }

    private FileInformation createFileInformation() {
        FileInformation inf;
        switch (this.informationLevel) {
            case 4: {
                inf = new FileBasicInfo();
                break;
            }
            case 5: {
                inf = new FileStandardInfo();
                break;
            }
            case 6: {
                inf = new FileInternalInfo();
                break;
            }
            default: {
                return null;
            }
        }
        return inf;
    }

    @Override
    public String toString() {
        return "Trans2QueryPathInformationResponse[" + super.toString() + "]";
    }
}

