/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.trans2;

import org.codelibs.jcifs.smb.CIFSException;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.AllocInfo;
import org.codelibs.jcifs.smb.internal.SMBProtocolDecodingException;
import org.codelibs.jcifs.smb.internal.fscc.FileFsFullSizeInformation;
import org.codelibs.jcifs.smb.internal.fscc.FileFsSizeInformation;
import org.codelibs.jcifs.smb.internal.fscc.FileSystemInformation;
import org.codelibs.jcifs.smb.internal.fscc.SmbInfoAllocation;
import org.codelibs.jcifs.smb.internal.smb1.trans.SmbComTransactionResponse;

public class Trans2QueryFSInformationResponse
extends SmbComTransactionResponse {
    private final int informationLevel;
    private FileSystemInformation info;

    public Trans2QueryFSInformationResponse(Configuration config, int informationLevel) {
        super(config);
        this.informationLevel = informationLevel;
        this.setCommand(50);
        this.setSubCommand((byte)3);
    }

    public int getInformationLevel() {
        return this.informationLevel;
    }

    public FileSystemInformation getInfo() {
        return this.info;
    }

    public <T extends FileSystemInformation> T getInfo(Class<T> clazz) throws CIFSException {
        if (!clazz.isAssignableFrom(this.info.getClass())) {
            throw new CIFSException("Incompatible file information class");
        }
        return (T)this.getInfo();
    }

    @Override
    protected int writeSetupWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeParametersWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readDataWireFormat(byte[] buffer, int bufferIndex, int len) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        AllocInfo inf = this.createInfo();
        if (inf != null) {
            bufferIndex += inf.decode(buffer, bufferIndex, this.getDataCount());
            this.info = inf;
        }
        return bufferIndex - start;
    }

    private AllocInfo createInfo() {
        AllocInfo inf;
        switch (this.informationLevel) {
            case -1: {
                inf = new SmbInfoAllocation();
                break;
            }
            case 3: {
                inf = new FileFsSizeInformation();
                break;
            }
            case 7: {
                inf = new FileFsFullSizeInformation();
                break;
            }
            default: {
                return null;
            }
        }
        return inf;
    }

    @Override
    public String toString() {
        return "Trans2QueryFSInformationResponse[" + super.toString() + "]";
    }
}

