/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.trans.nt;

import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.smb1.trans.nt.SmbComNtTransaction;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;
import org.codelibs.jcifs.smb.util.Hexdump;

public class NtTransQuerySecurityDesc
extends SmbComNtTransaction {
    int fid;
    int securityInformation;

    public NtTransQuerySecurityDesc(Configuration config, int fid, int securityInformation) {
        super(config, 6);
        this.fid = fid;
        this.securityInformation = securityInformation;
        this.setupCount = 0;
        this.totalDataCount = 0;
        this.maxParameterCount = 4;
        this.maxDataCount = 65536;
        this.maxSetupCount = 0;
    }

    @Override
    public int getPadding() {
        return 4;
    }

    @Override
    protected int writeSetupWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeParametersWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(this.fid, dst, dstIndex);
        dst[dstIndex += 2] = 0;
        int n = ++dstIndex;
        dst[n] = 0;
        SMBUtil.writeInt4(this.securityInformation, dst, ++dstIndex);
        return (dstIndex += 4) - start;
    }

    @Override
    protected int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    public String toString() {
        return "NtTransQuerySecurityDesc[" + super.toString() + ",fid=0x" + Hexdump.toHexString(this.fid, 4) + ",securityInformation=0x" + Hexdump.toHexString(this.securityInformation, 8) + "]";
    }
}

